<?php

defined('BASEPATH') or exit('No direct script access allowed');



class Casediary extends AdminController

{

    public function __construct()

    {

        parent::__construct();

        $this->load->model('casediary_model');

        $this->load->model('hearing_model'); 

    }

     public function conflict_search_history_table()
    {
        if ($this->input->is_ajax_request()) {
            $aColumns = [
                //db_prefix() . 'conflicts_search_history.id as id',
                'dateadded',
                'search_term',
                'addedfrom',
                'result',
                'notes',
                ];

            $sIndexColumn = 'id';
            $sTable       = db_prefix() . 'conflicts_search_history';

            $join = [];
            $where  = [];
            $filter = [];



            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, []);

            $output  = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = [];

                //$row[] = $aRow['id'];
                $row[] = _dt($aRow['dateadded']);

                $row[] = $aRow['search_term'];
                $row[] = $aRow['notes'];
                $row[] = get_staff_full_name($aRow['addedfrom']);
                $row[] = $aRow['result'];

                //$row = hooks()->apply_filters('contracts_table_row_data', $row, $aRow);

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
    }

    public function save_dashboard_conflict_search(){
        echo json_encode(array(
            'success' => $this->casediary_model->save_dashboard_conflict_search($this->input->post()),
        ));
    }



    public function get_payment_schedules_by_project($project_id){

         echo json_encode($this->casediary_model->get_payment_schedules('',$project_id));

    }



    



    public function remove_payment_schedule($project_id, $id)

    {

        $response = $this->casediary_model->remove_payment_schedule($id);



        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('payment_schedule')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('payment_schedule')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('payment_schedule')));

        }

        redirect(admin_url('projects/view/' . $project_id . '?group=project_payment_schedules'));

    }





    

      /* Add or update lead */

    public function payment_schedule($id = '')

    {



        if ($this->input->post()) {

            if ($id == '') {

                $id = $this->casediary_model->add_payment_schedule($this->input->post());

                $message = $id ? _l('added_successfully', _l('payment_schedule')) : '';



                echo json_encode([

                    'success'  => $id ? true : false,

                    'id'       => $id,

                    'message'  => $message,

                    'leadView' => $id ? $this->_get_payment_schedule_data($id) : [],

                ]);

            } else {

                

                $message         = '';

                $success = $this->casediary_model->update_payment_schedule($this->input->post(), $id);

                if ($success) {

                    $message = _l('updated_successfully', _l('payment_schedule'));

                }

                echo json_encode([

                    'success'          => $success,

                    'message'          => $message,

                    'id'               => $id,

                    'leadView'         => $this->_get_payment_schedule_data($id),

                ]);

            }

            die;

        }



        echo json_encode([

            'leadView' => $this->_get_payment_schedule_data($id),

        ]);

    }



     private function _get_payment_schedule_data($id = '')

    {

        $reminder_data         = '';

        $data = [];

        if (is_numeric($id)) {

            $hearing = $this->casediary_model->get_payment_schedules($id);

            if (!$hearing) {

                header('HTTP/1.0 404 Not Found');

                echo _l('not_found');

                die;

            }

            $data['payment_schedule'] = $hearing;   

        }

        if ($this->input->get('hearing_type')) {

            $hearing_type =  $this->input->get('hearing_type');

        }



        return [

            'data'          => $this->load->view('admin/projects/payment_schedule', $data, true),

            //'reminder_data' => $reminder_data,

        ];

    }





     public function newCourtInstance($id = '')

    {

        if (!is_admin() ) {

            access_denied('projects');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_new_court_instance($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('court_instance'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>create_slug($this->input->post('name')),

                    'slug'=>create_slug($this->input->post('name')),

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_court_instance($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('court_instance'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    }



    

    



    public function get_clients_of_oppositeparty($clientid)

    {

        if ($this->input->is_ajax_request()) {

            echo json_encode($this->casediary_model->get_clients_of_oppositeparty($clientid));

        }

    }

     

    

    

    public function get_casedetails_table_data_ajax($project_id, $htype)

    {

        if ($this->input->is_ajax_request()) {

            echo json_encode($this->casediary_model->get_details('',$project_id,$htype));

        }

    }

    

     public function edit_case_update($id)

    {

        if ($this->input->post()) { 

            $success = $this->casediary_model->edit_case_update($this->input->post(), $id);

            if ($success) { 

                //set_alert('success', _l('updated_successfully', _l('project_note')));

                echo json_encode(array(

                'success' => $success,

                'message' => _l('updated_successfully')

            ));

            }

            //redirect(admin_url('casediary/view/' . $project_id . '?group=project_notes'));

        }





    }

    public function delete_case_update($id)

    {

        if (!is_staff_member() ) {

            $this->access_denied_ajax();

        }

        echo json_encode(array(

            'success' => $this->casediary_model->delete_case_update($id),

        ));

    }



    public function save_case_update($project_id)

    {

        if ($this->input->post()) {

            $success = $this->casediary_model->save_case_update($this->input->post(null, false), $project_id);

            if ($success) {

                set_alert('success', _l('added_successfully', _l('case_update')));

            }

            redirect(admin_url('projects/view/' . $project_id . '?group=project_updates'));

        }

    }



    public function get_legal_summary_monthly()

    {

        

        $month = $this->input->post('month');

        $year  = $this->input->post('year');

        

        $where_month = 'MONTH(dateadded) = '.$month .' AND  YEAR(dateadded) = '.$year;



        $total_legal_enq = total_rows('tblleads',$where_month);

        $where_month = "MONTH(meeting_date) = ".$month.' AND YEAR(meeting_date) = '.$year;



        // Meetings

        $total_meetings = total_rows('tblprojectdiscussions',$where_month);

        $total_meetings_with_team = total_rows('tblprojectdiscussions',$where_month.' AND meeting_with="Team" ');

        $total_meetings_with_lawyers = total_rows('tblprojectdiscussions',$where_month.' AND meeting_with="Lawyers" ');

        $total_meetings_with_clients = total_rows('tblprojectdiscussions',$where_month.' AND meeting_with="Clients/Potential" ');





        // Proposal

        $where_month = "MONTH(date) = ".$month.' AND YEAR(date)='.$year;

        $total_proposals_sent = total_rows('tblproposals',$where_month);

        $where_paid = "MONTH(date) = ".$month.' AND status = 7 AND YEAR(date)='.$year;

        $paid_proposals = total_rows('tblproposals',$where_paid);

        $where_paid = "YEAR(date) = ".$year;

        $current_year_proposals = total_rows('tblproposals',$where_paid);



        $where_paid = "YEAR(date) < ".$year;

        $pre_years_proposals = total_rows('tblproposals',$where_paid);



        // Cases exclude Not Started



        $cases_registered = total_rows('tblprojects',"status != 1 AND MONTH(start_date)=".$month." AND YEAR(start_date)=".$year);

        $cases_registered_current_year = total_rows('tblprojects',"status != 1 AND YEAR(start_date)=".$year);

        $cases_registered_until_current_year = total_rows('tblprojects',"status != 1 AND YEAR(start_date) < ".$year);  



         // Cases only Not Started



        $cases_under_registration = total_rows('tblprojects',"status = 1 AND MONTH(start_date)=".$month." AND YEAR(start_date)=".$year);

        $cases_under_registration_current_year = total_rows('tblprojects',"status = 1 AND YEAR(start_date)=".$year);

        $cases_under_registration_until_current_year = total_rows('tblprojects',"status = 1 AND YEAR(start_date) < ".$year);       



        $response['month'] = '<tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">1. No of Legal Enquiries </li>

                                

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$total_legal_enq.'</li>

                            </ul>

                        </td>

                    </tr>



                    <tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">2 . Total Meetings</li>

                                <li class="list-group-item">   No of Meetings with the Team</li>

                                <li class="list-group-item">   No of Meetings with Lawyers</li>

                                <li class="list-group-item">   No. of meetings with Clients/potential</li>

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$total_meetings.'</li>

                              <li class="list-group-item">'.$total_meetings_with_team.'</li>

                              <li class="list-group-item">'.$total_meetings_with_lawyers.'</li>

                              <li class="list-group-item">'.$total_meetings_with_clients.'</li>

                            </ul>

                        </td>

                    </tr>



                    <tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">3 . No of proposals Sent</li>

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$total_proposals_sent.'</li>

                            </ul>

                        </td>

                    </tr>



                    <tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">4 . No of proposals paid</li>

                                <li class="list-group-item"> '.$year.' proposals</li>

                                <li class="list-group-item">'.($year - 1) .'  & earlier proposals</li>

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$paid_proposals.'</li>

                              <li class="list-group-item">'.$pre_years_proposals.'</li>

                              <li class="list-group-item">'.$pre_years_proposals.'</li>

                            </ul>

                        </td>

                    </tr>



                    <tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">5 . No of cases Registered </li>

                                <li class="list-group-item"> '.$year.' cases</li>

                                <li class="list-group-item">'.($year - 1) .'  & earlier cases</li>

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$cases_registered.'</li>

                              <li class="list-group-item">'.$cases_registered_current_year.'</li>

                              <li class="list-group-item">'.$cases_registered_until_current_year.'</li>

                            </ul>

                        </td>

                    </tr>



                     <tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">6 . No of Cases Under Registration  </li>

                                <li class="list-group-item">Old Cases (before '.$year  .')</li>

                                <li class="list-group-item">In the year '.$year.'</li>

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'. $cases_under_registration.'</li>

                              <li class="list-group-item">'.$cases_under_registration_until_current_year.'</li>

                              <li class="list-group-item"> '.$cases_under_registration_current_year.'</li>

                            </ul>

                        </td>

                    </tr>';



        $qrmonth = $this->input->post('qr_month');

        $year  = $this->input->post('qr_year');

        if($qrmonth == 'q1'){

            $month = "1,2,3";

        }elseif($qrmonth == 'q2'){

            $month = "4,5,6";

        }elseif($qrmonth == 'q3'){

            $month = "7,8,9";

        }elseif($qrmonth == 'q4'){

            $month = "10,11,12";

        }

        $where_month = 'MONTH(dateadded) IN ('.$month .') AND  YEAR(dateadded) = '.$year;



        $total_legal_enq = total_rows('tblleads',$where_month);

        $where_month = "MONTH(meeting_date) IN (".$month.') AND YEAR(meeting_date) = '.$year;



        // Meetings

        $total_meetings = total_rows('tblprojectdiscussions',$where_month);

        $total_meetings_with_team = total_rows('tblprojectdiscussions',$where_month.' AND meeting_with="Team" ');

        $total_meetings_with_lawyers = total_rows('tblprojectdiscussions',$where_month.' AND meeting_with="Lawyers" ');

        $total_meetings_with_clients = total_rows('tblprojectdiscussions',$where_month.' AND meeting_with="Clients/Potential" ');





        // Proposal

        $where_month = "MONTH(date) IN (".$month.') AND YEAR(date)='.$year;

        $total_proposals_sent = total_rows('tblproposals',$where_month);

        $where_paid = "MONTH(date) IN (".$month.') AND status = 7 AND YEAR(date)='.$year;

        $paid_proposals = total_rows('tblproposals',$where_paid);

        $where_paid = "YEAR(date) = ".$year;

        $current_year_proposals = total_rows('tblproposals',$where_paid);



        $where_paid = "YEAR(date) < ".$year;

        $pre_years_proposals = total_rows('tblproposals',$where_paid);



        // Cases exclude Not Started



        $cases_registered = total_rows('tblprojects',"status != 1 AND MONTH(start_date) IN (".$month.") AND YEAR(start_date)=".$year);

        $cases_registered_current_year = total_rows('tblprojects',"status != 1 AND YEAR(start_date)=".$year);

        $cases_registered_until_current_year = total_rows('tblprojects',"status != 1 AND YEAR(start_date) < ".$year);             

        $response['quarter'] = '<tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">1. No of Legal Enquiries </li>

                                

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$total_legal_enq.'</li>

                            </ul>

                        </td>

                    </tr>



                    <tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">2 . Total Meetings</li>

                                <li class="list-group-item">   No of Meetings with the Team</li>

                                <li class="list-group-item">   No of Meetings with Lawyers</li>

                                <li class="list-group-item">   No. of meetings with Clients/potential</li>

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$total_meetings.'</li>

                              <li class="list-group-item">'.$total_meetings_with_team.'</li>

                              <li class="list-group-item">'.$total_meetings_with_lawyers.'</li>

                              <li class="list-group-item">'.$total_meetings_with_clients.'</li>

                            </ul>

                        </td>

                    </tr>



                    <tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">3 . No of proposals Sent</li>

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$total_proposals_sent.'</li>

                            </ul>

                        </td>

                    </tr>



                    <tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">4 . No of proposals paid</li>

                                <li class="list-group-item"> '.$year.' proposals</li>

                                <li class="list-group-item">'.($year - 1) .'  & earlier proposals</li>

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$paid_proposals.'</li>

                              <li class="list-group-item">'.$pre_years_proposals.'</li>

                              <li class="list-group-item">'.$pre_years_proposals.'</li>

                            </ul>

                        </td>

                    </tr>



                    <tr>

                        <td>

                            <ul class="list-group list-group-flush">

                                <li class="list-group-item active2">5 . No of cases Registered </li>

                                <li class="list-group-item"> '.$year.' cases</li>

                                <li class="list-group-item">'.($year - 1) .'  & earlier cases</li>

                            </ul>

                        </td>

                        <td>

                            <ul class="list-group list-group-flush">

                              <li class="list-group-item active2">'.$cases_registered.'</li>

                              <li class="list-group-item">'.$cases_registered_current_year.'</li>

                              <li class="list-group-item">'.$cases_registered_until_current_year.'</li>

                            </ul>

                        </td>

                    </tr>



                     ';           

        echo json_encode($response);



        /*<li class="list-group-item">  No of legal opinion provided from Mosab</li>

                                <li class="list-group-item">  No of legal opinion provided from lawyers</li>*/



    }



   

    public function courts()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('my_courts');

        }

        $data['title'] = _l('courts');

        $this->load->view('admin/casediary/manage_courts', $data);

    }

    public function court_instances()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('my_court_instances');
        }
        $data['title'] = _l('court_instance');
        $this->load->view('admin/casediary/manage_court_instances', $data);
    }

     public function delete_court_instance($id)
    {
        if (!$id) {
            redirect(admin_url('casediary/court_instance'));
        }
        $response = $this->casediary_model->delete_court_instance($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('court_instance')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('court_instance')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('court_instance')));
        }
        redirect(admin_url('casediary/court_instances'));
    }

    public function partytypes()
    {
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('my_partytypes');
        }
        $data['title'] = _l('casediary_partytype');
        $this->load->view('admin/casediary/manage_party_types', $data);
    }

    public function new_partytype($id = '')
    {
        if (!is_admin() && !is_client_admin() ) {
            access_denied('projects');
        }
        if ($this->input->post()) {
            if (!$this->input->post('id')) {
                $id = $this->casediary_model->add_new_partytype($this->input->post());
                if ($id) {
                    $success = true;
                    $message = _l('added_successfully', _l('casediary_partytype'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message' => $message,
                    'id'=>$id,
                    'name'=>$this->input->post('name'),
                ));
            } else {
                $data = $this->input->post();
                $id   = $data['id'];
                unset($data['id']);
                $success = $this->casediary_model->update_party_type($data, $id);
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('casediary_partytype'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message' => $message,
                ));
            }
        }
    }

    public function delete_partytype($id)
    {
        if (!$id) {
            redirect(admin_url('casediary/partytypes'));
        }
        $response = $this->casediary_model->delete_partytype($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('casediary_partytype')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('casediary_partytype')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('casediary_partytype')));
        }
        redirect(admin_url('casediary/partytypes'));
    }

    

      /* Delete announcement from database */

    public function delete_court($id)

    {

        if (!$id) {

            redirect(admin_url('casediary/courts'));

        }

        

        $response = $this->casediary_model->delete_court($id);

        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('court')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('court')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('court')));

        }

        redirect(admin_url('casediary/courts'));

    }





    public function court_types()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('court_types');

        }

        $data['title'] = _l('court_types');

        $this->load->view('admin/casediary/manage_court_types', $data);

    }



   



     /* Delete announcement from database */

    public function delete_court_type($id)

    {

        if (!$id) {

            redirect(admin_url('hearing/court_types'));

        }

        

        $response = $this->casediary_model->delete_court_type($id);

        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('hearing_court_type')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('hearing_court_type')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('hearing_court_type')));

        }

        redirect(admin_url('hearing/court_types'));

    }



  

    /* Delete announcement from database */

    public function delete_court_region($id)

    {

        if (!$id) {

            redirect(admin_url('casediary/court_regions'));

        }

        

        $response = $this->casediary_model->delete_court_region($id);

        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('hearing_court_region')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('hearing_court_region')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('hearing_court_region')));

        }

        redirect(admin_url('casediary/court_regions'));

    }



    public function opposite_parties()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('my_opposite_parties');

        }

        $data['title'] = _l('opposite_parties');

        $this->load->view('admin/casediary/manage_opposite_party', $data);

    }



   



   



    /* Delete announcement from database */

    public function delete_hearing_reference($id)

    {

        if (!$id) {

            redirect(admin_url('casediary/hearing_references'));

        }

        

        $response = $this->casediary_model->delete_hearing_reference($id);

        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('hearing_reference')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('hearing_reference')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('hearing_reference')));

        }

        redirect(admin_url('casediary/hearing_references'));

    }



   



   /* public function export_project_data($id)

    {

        if (staff_can('create', 'projects')) {

        if (!$id) {

            redirect(admin_url('projects'));

        }

        $hearing =  $this->hearing_model->get($id, array(), true);



        try {

            $pdf = hearing_notice_pdf($hearing);

        } catch (Exception $e) {

            echo $e->getMessage();

            die;

        }



        $type = 'D';



        if ($this->input->get('output_type')) {

            $type = $this->input->get('output_type');

        }



        if ($this->input->get('print')) {

            $type = 'I';

        }



        $pdf->Output(slug_it($hearing->subject) . '.pdf', $type);

        }

    }*/



    public function get_case_data_ajax($id, $to_return = false)

    {

        if (!has_permission('projects', '', 'view') && !has_permission('projects', '', 'view_own') ) {

            echo _l('access_denied');

            die;

        }



        $hearing = $this->hearing_model->get($id);



        if (!$hearing ) {

            echo _l('hearing_not_found');

            die;

        }

        $data['hearing_types']     =  get_hearing_types();

        $data['hearing_preview']           = $hearing;

        if ($to_return == false) {

            $this->load->view('admin/projects/hearing_preview_template', $data);

        } else {

            return $this->load->view('admin/projects/hearing_preview_template', $data, true);

        }

    }







    public function upload_hearing_attachments($hearingid,$project_id)

    {

        handle_hearing_attachment($hearingid,$project_id);

    }





   





      /* Add new task or update existing */

    public function task_temp($id = '')

    {

        if (!has_permission('tasks', '', 'edit') && !has_permission('tasks', '', 'create')) {

            access_denied('Tasks');

        }



        $data = array();

        // FOr new task add directly from the projects milestones

        if ($this->input->get('milestone_id')) {

            $this->db->where('id', $this->input->get('milestone_id'));

            $milestone = $this->db->get('tblmilestones')->row();

            if ($milestone) {

                $data['_milestone_selected_data'] = array(

                    'id' => $milestone->id,

                    'due_date' => _d($milestone->due_date),

                );

            }

        }

        if ($this->input->get('start_date')) {

            $data['start_date'] = $this->input->get('start_date');

        }

        if ($this->input->post()) {

            $data                = $this->input->post();

            $data['description'] = $this->input->post('description', false);

            if ($id == '') {

                if (!has_permission('tasks', '', 'create')) {

                    header('HTTP/1.0 400 Bad error');

                    echo json_encode(array(

                        'success' => false,

                        'message' => _l('access_denied'),

                    ));

                    die;

                }

                $id      = $this->tasks_model->add_template_task($data);

                $_id     = false;

                $success = false;

                $message = '';

                if ($id) {

                    $success = true;

                    $_id     = $id;

                    $message = _l('added_successfully', _l('task'));

                    $uploadedFiles = handle_task_attachments_array($id);

                    if ($uploadedFiles && is_array($uploadedFiles)) {

                        foreach ($uploadedFiles as $file) {

                            $this->misc_model->add_attachment_to_database($id, 'task', array($file));

                        }

                    }

                }

                echo json_encode(array(

                    'success' => $success,

                    'id' => $_id,

                    'message' => $message,

                ));

            } else {

                if (!has_permission('tasks', '', 'edit')) {

                    header('HTTP/1.0 400 Bad error');

                    echo json_encode(array(

                        'success' => false,

                        'message' => _l('access_denied'),

                    ));

                    die;

                }

                $success = $this->tasks_model->update_template_task($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('task'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id' => $id,

                ));

            }

            die;

        }



        $data['milestones'] = array();

        $data['checklistTemplates'] = $this->tasks_model->get_checklist_templates();

        if ($id == '') {

            $title = _l('add_new', _l('task_lowercase'));

        } else {

            $data['task'] = $this->tasks_model->get_temp_task($id);

            /*if ($data['task']->rel_type == 'project') {

                $data['milestones'] = $this->projects_model->get_milestones($data['task']->rel_id);

            }*/

            //if ($data['task']->rel_type == 'project') {

            $this->load->model('casetemplate_model');

            $data['milestones'] = $this->casetemplate_model->get_milestones($data['task']->rel_id);

            //}

            $title = _l('edit', _l('task_lowercase')) . ' ' . $data['task']->name;

        }

        $data['project_end_date_attrs'] = array();

        if ($this->input->get('rel_type') == 'project' && $this->input->get('rel_id')) {

            $project = '';//$this->projects_model->get($this->input->get('rel_id'));

            if ($project->deadline) {

                $data['project_end_date_attrs'] = array(

                    'data-date-end-date' => $project->deadline,

                );

            }

        }

        $data['id']    = $id;

        $data['title'] = $title;

        $this->load->view('admin/tasks/task_template', $data);

    }



    public function get_matter_templates_by_case_type($casetype){

        if($casetype){

            $matter_templates = $this->casediary_model->get_matter_templates_by_case_type($casetype);

            echo json_encode($matter_templates);

        }else{

            return false;

        }

    }



      public function scope($id = '')

    {

        if ($this->input->post()) {

            $message = '';

            $success = false;

            if (!$this->input->post('id')) {

                $project_id = $this->input->post('case_id');

                $id = $this->casediary_model->add_scope($this->input->post());

                if ($id) {

                    set_alert('success', _l('added_successfully', _l('scope')));

                    redirect(admin_url('projects/view/' . $project_id . '?group=scope'));

                }

                

            }

            die;

        }

    }



     public function edit_scope($id)

    {

        if ($this->input->post()) {

            $success = $this->casediary_model->edit_scope($this->input->post(), $id);

            echo json_encode(array(

                'success' => $success,

                'message' => _l('scope_updated_successfully'),

            ));

        }

    }



    public function delete_scope($project_id, $id)

    {

        

        if ($this->casediary_model->delete_scope($id)) {

            set_alert('success', _l('deleted'));

        }

        

        redirect(admin_url('projects/view/' . $project_id . '?group=scope'));

    }



    public function designations()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('designations');

        }

        $data['title'] = _l('designations');

        $this->load->view('admin/staff/manage_designations', $data);

    }



    

    

    /* Manage Designation Since Version 1.0.3 */

    public function designation($id = '')

    {

        if (!is_admin() && !is_client_admin()) {

            access_denied('staff/designations');

        }

        $this->load->model('designations_model');



        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->designations_model->add($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('designation'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->designations_model->update($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('designation'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    }

      /* Delete announcement from database */

    public function delete_designation($id)

    {

        if (!$id) {

            redirect(admin_url('casediary/designations'));

        }

        $this->load->model('designations_model');

        $response = $this->designations_model->delete($id);

        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('designation')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('designation')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('designation')));

        }

        redirect(admin_url('casediary/designations'));

    }





    public function case_nature()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('my_case_nature');

        }

        $data['title'] = _l('case_nature');

        $this->load->view('admin/casediary/manage_case_nature', $data);

    }



     public function newCaseNature($id = '')

    {

        if (!is_admin() && !is_client_admin() ) {

            access_denied('projects');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_case_nature($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('case_nature'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_case_nature($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('case_nature'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    } 



       /* Delete announcement from database */

    public function delete_case_nature($id)

    {

        if (!$id) {

            redirect(admin_url('casediary/case_nature'));

        }

        

        $response = $this->casediary_model->delete_case_nature($id);



        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('case_nature')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('case_nature')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('case_nature')));

        }

        redirect(admin_url('casediary/case_nature'));

    }



      /* Delete announcement from database */

    public function delete_hall_number($id)

    {

        if (!$id) {

            redirect(admin_url('casediary/hallnumbers'));

        }

        

        $response = $this->casediary_model->delete_hall_number($id);



        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('casediary_hallnumber')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('casediary_hallnumber')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('casediary_hallnumber')));

        }

        redirect(admin_url('casediary/hallnumbers'));

    }



     public function newCourt($id = '')

    {

        if (!is_admin() && !is_client_admin() ) {

            access_denied('projects');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_new_court($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('court'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_court($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('court'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    }

    





        /* Manage Court type Since Version 1.0.3 */

    public function newCourtType($id = '')

    {

        if (!is_admin() && !is_client_admin() ) {

            access_denied('hearings');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_new_CourtType($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('hearing_court_type'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_court_type($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('hearing_court_type'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    }



     /* Manage Area Descriptions Since Version 1.0.3 */

    public function newCourtDegree($id = '')

    {

        if (!is_admin() && !is_client_admin()) {

            access_denied('hearings');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_new_court_degree($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('hearing_court_degree'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->contracts_model->update_contract_type($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('hearing_court_degree'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    }



       /* Manage Hallnnumber Since Version 1.0.3 */

    public function new_court_regions($id = '')

    {

        if (!is_admin() && !is_client_admin() ) {

            access_denied('hearings');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_new_court_regions($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('hearing_court_region'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_court_region($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('hearing_court_region'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    }



     public function new_opposite_party($id = '')

    {

        if (!is_admin() && !is_client_admin() ) {

            access_denied('casediary');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_new_oppositeparty($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('casediary_oppositeparty'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_contract_type($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('casediary_oppositeparty'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    }


     /* Manage contract types Since Version 1.0.3 */

    public function newhearing_reference($id = '')

    {

        if (!is_admin() && !is_client_admin() ) {

            access_denied('hearings');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_new_hearing_reference($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('hearing_reference'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_hearing_reference($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('hearing_reference'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    }



      public function newhallnumber($id = '')

    {

        if (!is_admin() && !is_client_admin() ) {

            access_denied('casediary');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_new_hallnumber($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('casediary_hallnumber'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_hall_number($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('casediary_hallnumber'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    }



     public function hearing_references()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('my_hearing_references');

        }

        $data['title'] = _l('hearing_references');

        $this->load->view('admin/casediary/manage_hearing_references', $data);

    }



     public function court_regions()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('my_court_regions');

        }

        $data['title'] = _l('court_region');

        $this->load->view('admin/casediary/manage_court_regions', $data);

    }



    public function hallnumbers()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('my_hallnumbers');

        }

        $data['title'] = _l('hallnumber');

        $this->load->view('admin/casediary/manage_hall_numbers', $data);

    }





     public function document_types()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('my_document_types');

        }
        $data['category']    = $this->casediary_model->get_courtordernames();

        $data['title'] = _l('document_types');

        $this->load->view('admin/casediary/manage_document_types', $data);

    }



     public function newDocumentType($id = '')

    {

        if (!is_admin() && !is_client_admin() ) {

            access_denied('projects');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_document_type($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('document_type'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_document_type($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('document_type'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    } 



       /* Delete announcement from database */

    public function delete_document_type($id)

    {

        if (!$id) {

            redirect(admin_url('casediary/document_types'));

        }

        

        $response = $this->casediary_model->delete_document_type($id);



        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('document_type')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('document_type')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('document_type')));

        }

        redirect(admin_url('casediary/document_types'));

    }

	

	 public function change_status($stable,$id, $status){

        if ($this->input->is_ajax_request()) {

            $this->casediary_model->verify_status($id,$stable,$status);

        }

    }


    public function run_party_type_update_query(){

        $old_party_types = array(
            array('id'=>'defendant','name'=>'Defendant-المدعى عليه','newid'=>1),
            array('id'=>'plaintiff','name'=>'Plaintiff - مدعي  ','newid'=>2),
            array('id'=>'petitioner','name'=>'Petitioner -  الملتمس,   ','newid'=>3),
            array('id'=>'witness','name'=>"Witness - شاهد  ",'newid'=>4),
            array('id'=>'challenger','name'=>"Challenger -  المعترض  ",'newid'=>5),
            array('id'=>'challenged','name'=>"Challenged - المعترض عليه ",'newid'=>6),
            array('id'=>'claimant','name'=>"Claimant - المحتكمة ",'newid'=>7),
            array('id'=>'respondent','name'=>"Respondent -  المحتكم ضدها ",'newid'=>8),
            array('id'=>'applicant','name'=>"Applicant - الطالب",'newid'=>9),
            array('id'=>'complainant','name'=>"Complainant -  المشتكي ",'newid'=>10),
            array('id'=>'accused','name'=>"Accused - المتهم ",'newid'=>11)
        );

        $case_details_table = $this->db->get('tblcase_details')->result_array();

        foreach ($case_details_table as  $value) {
            foreach ($old_party_types as $old_party_type) {
                if($value['client_position']  == $old_party_type['id']){
                    $this->db->where('id',$value['id']);
                    $this->db->update('tblcase_details',array('client_position'=>$old_party_type['newid']));
                    echo '<br>Updated'.$value['id'];
                }

                if($value['opposite_party_position']  == $old_party_type['id']){
                    $this->db->where('id',$value['id']);
                    $this->db->update('tblcase_details',array('opposite_party_position'=>$old_party_type['newid']));
                    echo '<br>oppo--Updated'.$value['id'];
                }
            }
            
        }

        $hearings_table = $this->db->get('tblhearings')->result_array();

        foreach ($hearings_table as  $hvalue) {
            foreach ($old_party_types as $old_party_type) {
                if($hvalue['h_client_position']  == $old_party_type['id']){
                    $this->db->where('id',$hvalue['id']);
                    $this->db->update('tblhearings',array('h_client_position'=>$old_party_type['newid']));
                    echo '<br>Updated'.$hvalue['id'];
                }

                if($hvalue['h_oppositeparty_position']  == $old_party_type['id']){
                    $this->db->where('id',$hvalue['id']);
                    $this->db->update('tblhearings',array('h_oppositeparty_position'=>$old_party_type['newid']));
                    echo '<br>oppo--Updated'.$hvalue['id'];
                }
            }
            
        }

    }

    public function run_client_no_auto_set()
    {
        $start = 1001;
        $clients = $this->db->order_by('userid','ASC')->get('tblclients')->result_array();
        foreach ($clients as $client) {
            $set['client_no'] = $start++;
            $set['country'] = 234;
            $set['default_currency'] = 3;
            $set['default_language'] = 'english';
            $this->db->where('userid',$client['userid']);
            $this->db->update('tblclients',$set);
        }
    }

    public function move_opposite_party_to_multiple_rel_table()
    {
        $projects = $this->db->get('tblprojects')->result_array();
        foreach ($projects as $value) {
            if(is_numeric($value['opposite_party']) && $value['opposite_party'] > 0){
                $check_already_inserted = total_rows('tblproject_opposite_parties',['project_id'=>$value['id'],'opposite_party_id'=>$value['opposite_party']]);
                if($check_already_inserted > 0){
                    continue;
                }else{
                    $this->db->insert('tblproject_opposite_parties',['project_id'=>$value['id'],'opposite_party_id'=>$value['opposite_party']]);
                }
            }
        }

        redirect(admin_url());
    }

    public function courtorder($id = '')

    {

        if ($this->input->post()) {

            $message = '';

            $success = false;

            if (!$this->input->post('id')) {

                $project_id = $this->input->post('project_id');

                $id = $this->casediary_model->add_courtorder($this->input->post());

                if ($id) {

                    set_alert('success', _l('added_successfully', _l('project_courts')));

                    //redirect(admin_url('projects/view/' . $project_id . '?group=court_order'));

                echo json_encode([

                    'url'       => admin_url('projects/view/' . $project_id . '/?group=court_order'),

                    'orderid' => $id,

                ]);

                die;

            }

            echo json_encode([

                'url' => admin_url('projects/view/' .$project_id . '/?group=court_order'),

            ]);

            die;

        }

    }

}


    public function edit_courtorder($id)
    {
        if ($this->input->post()) {
            $success = $this->casediary_model->edit_courtorder($this->input->post(), $id);
            echo json_encode(array(
              'success' => $success,
              'message' => _l('updated_successfully'),
           ));
        }
    }

    public function delete_courtorder($project_id, $id)
    {
        if ($this->casediary_model->delete_courtorder($id)) {
            set_alert('success', _l('deleted'));
        }
        redirect(admin_url('projects/view/' . $project_id . '?group=court_order'));
    }

    public function verify_courtorder($id, $status){
        if ($this->input->is_ajax_request()) {
            $this->casediary_model->verify_status($id,'tblcourt_orders',$status);
        }
    }

    public function u_s(){
        $settings = $this->db->get('tblproject_settings')->result_array();

        foreach ($settings as $value) {
           
            if($value['name'] == 'available_features'){
                $this->db->where('id',$value['id']);
                $this->db->update('tblproject_settings',['value'=>'a:22:{s:16:"project_overview";i:1;s:20:"project_case_details";i:1;s:8:"hearings";i:1;s:13:"project_tasks";i:1;s:15:"project_updates";i:1;s:17:"project_reminders";i:1;s:13:"project_files";i:1;s:25:"project_payment_schedules";i:1;s:16:"project_invoices";i:1;s:17:"project_estimates";i:1;s:16:"project_expenses";i:1;s:20:"project_credit_notes";i:1;s:13:"project_notes";i:1;s:16:"project_activity";i:1;s:18:"project_timesheets";i:0;s:18:"project_milestones";i:0;s:5:"scope";i:0;s:11:"case_emails";i:0;s:19:"project_discussions";i:0;s:13:"project_gantt";i:0;s:15:"project_tickets";i:0;s:17:"project_contracts";i:0;}']);
            }
        }
    }
 public function case_arbitration()

    {

        if ($this->input->is_ajax_request()) {

            $this->app->get_table_data('my_case_arbitration');

        }

        $data['title'] = _l('case_arbitration');

        $this->load->view('admin/casediary/manage_case_arbitration', $data);

    }



     public function newCaseArbitration($id = '')

    {

        if (!is_admin() && !is_client_admin() ) {

            access_denied('projects');

        }

        if ($this->input->post()) {

            if (!$this->input->post('id')) {

                $id = $this->casediary_model->add_case_arbitration($this->input->post());

                if ($id) {

                    $success = true;

                    $message = _l('added_successfully', _l('case_arbitration'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                    'id'=>$id,

                    'name'=>$this->input->post('name'),

                ));

            } else {

                $data = $this->input->post();

                $id   = $data['id'];

                unset($data['id']);

                $success = $this->casediary_model->update_case_arbitration($data, $id);

                $message = '';

                if ($success) {

                    $message = _l('updated_successfully', _l('case_arbitration'));

                }

                echo json_encode(array(

                    'success' => $success,

                    'message' => $message,

                ));

            }

        }

    } 



       /* Delete announcement from database */

    public function delete_case_arbitration($id)

    {

        if (!$id) {

            redirect(admin_url('casediary/case_arbitration'));

        }

        

        $response = $this->casediary_model->delete_case_arbitration($id);



        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('case_arbitration')));

        } elseif ($response == true) {

            set_alert('success', _l('deleted', _l('case_arbitration')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('case_arbitration')));

        }

        redirect(admin_url('casediary/case_arbitration'));

    }

}