<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Opposite_parties extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('oppositeparty_model');   
     
    }

    /* List all opposite parties */
    public function index()
    {
        
        $opps = $this->oppositeparty_model->get();

        foreach($opps as $opp){

            if($opp['id'] != 1) {

                $num = total_rows('tblcase_details',array('opposite_party'=>$opp['id']));
                if($num <= 0){
                $project_res = $this->db->get_where('tblprojects',array('id'=>1))->result_array();
                $project = $project_res[0];

                unset($project['id']);
                $project['name'] = 'Case Against - '.$opp['name'];
                $project['clientid'] = $opp['client_id'];
                $next_file_number    = get_option('next_file_number');
                $_file_number = str_pad($next_file_number, get_option('number_padding_prefixes'), '0', STR_PAD_LEFT);
                $prefix = get_option('file_no_prefix');
                $project['file_no'] = $prefix.$_file_number;
                

                $this->db->insert('tblprojects',$project);
                $project_id = $this->db->insert_id();

                    $this->db->where('name', 'next_file_number');
                    $this->db->set('value', 'value+1', false);
                    $this->db->update('tbloptions');


                $setttings_res = $this->db->get_where('tblproject_settings',array('project_id'=>1))->result_array();

                 foreach ($setttings_res as $value) {
                    unset($value['id']);
                    $value['project_id'] = $project_id;

                    $this->db->insert('tblproject_settings',$value);
                 }


                $activity_res = $this->db->get_where('tblproject_activity',array('project_id'=>1))->result_array();

                foreach ($activity_res as $avalue) {
                
                    unset($avalue['id']);
                    $avalue['project_id'] = $project_id;

                    $this->db->insert('tblproject_activity',$avalue);
                }

                $member['project_id'] = $project_id;
                $member['staff_id'] = 3;
                $this->db->insert('tblproject_members',$member);

                $details_res = $this->db->get_where('tblcase_details',array('project_id'=>1))->result_array();

                $details = $details_res[0];
        
                unset($details['id']);
                $details['project_id'] = $project_id;
                $details['opposite_party'] = $opp['id'];
                $this->db->insert('tblcase_details',$details);

                }

                //return false;
            }

        }




        close_setup_menu();

        if (!has_permission('projects', '', 'view') && !has_permission('projects', '', 'view_own')) {
            access_denied('projects');
        }

        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('my_opposite_parties');
        }

        $data['title'] = _l('opposite_parties');
        $this->load->view('admin/casediary/manage_opposite_party', $data);
    }

     /* Edit client or add new client*/
    public function opposite_party($id = '')
    {
        if (!has_permission('projects', '', 'view')) {
            if ($id != '' && !is_customer_admin($id)) {
                access_denied('projects');
            }
        }
        if ($this->input->post() && !$this->input->is_ajax_request()) {
            if ($id == '') {
                if (!has_permission('projects', '', 'create')) {
                    access_denied('projects');
                }

                $data                 = $this->input->post();
                $id = $this->oppositeparty_model->add($data);
                
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('opposite_party')));
                    redirect(admin_url('opposite_parties'));
                }
            } else {
                if (!has_permission('projects', '', 'edit')) {
                    access_denied('projects');
                }
                $success = $this->oppositeparty_model->update($this->input->post(), $id);
                if ($success == true) {
                    set_alert('success', _l('updated_successfully', _l('opposite_party')));
                }
                redirect(admin_url('opposite_parties'));
            }
        }

        if ($id == '') {
            $title = _l('add_new', _l('opposite_party'));
        } else {
            $client = $this->oppositeparty_model->get($id);
            if (!$client) {
                blank_page('Opposite Party Not Found');
            }

            $data['opposite_party']        = $client;
            $title                 = $client->name;
            
        }
        $data['title'] = $title;

        $this->load->view('admin/casediary/opposite_party_view', $data);
    }

     /* Delete opposite_party */
    public function delete($id)
    {
        if (!has_permission('projects', '', 'delete')) {
            access_denied('opposite_parties');
        }
        if (!$id) {
            redirect(admin_url('opposite_parties'));
        }
        $response = $this->oppositeparty_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('delete_transactions_warning',_l('opposite_party')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('opposite_party')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('opposite_party')));
        }
        redirect(admin_url('opposite_parties'));
    }



}
    