<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Public_weblinks extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('public_weblinks_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('public_weblink', '', 'view')) {
            access_denied('public_weblinks');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('public_weblinks');
        }
      
        $data['bodyclass'] = 'top-tabs kan-ban-body';
        $data['title']     = _l('public_weblinks');
        $this->load->view('admin/public_weblinks/weblinks', $data);
    }

    /* Add new weblink or edit existing*/
    public function weblink($id = '')
    {
        if (!has_permission('public_weblink', '', 'view')) {
            access_denied('public_weblinks');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            $data['description'] = html_purify($this->input->post('description', false));

            if ($id == '') {
                if (!has_permission('public_weblink', '', 'create')) {
                    access_denied('public_weblinks');
                }
                $id = $this->public_weblinks_model->add_weblink($data);
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('public_weblink')));
                    redirect(admin_url('public_weblinks/weblink/' . $id));
                }
            } else {
                if (!has_permission('public_weblink', '', 'edit')) {
                    access_denied('public_weblinks');
                }
                $success = $this->public_weblinks_model->update_weblink($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('public_weblink')));
                }
                redirect(admin_url('public_weblinks/weblink/' . $id));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('public_weblink'));
        } else {
            $weblink         = $this->public_weblinks_model->get($id);
            $data['article'] = $weblink;
            $title           = _l('edit', _l('public_weblink')) . ' ' . $weblink->name;
        }

        $this->app_scripts->add('tinymce-stickytoolbar',site_url('assets/plugins/tinymce-stickytoolbar/stickytoolbar.js'));

        $data['bodyclass'] = 'kb-article';
        $data['title']     = $title;
        $this->load->view('admin/public_weblinks/weblink', $data);
    }

    /* Change article active or inactive */
    public function change_weblink_status($id, $status)
    {
        if (has_permission('public_weblink', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->public_weblinks_model->change_weblink_status($id, $status);
            }
        }
    }



    /* Delete article from database */
    public function delete_weblink($id)
    {
        if (!has_permission('public_weblink', '', 'delete')) {
            access_denied('public_weblinks');
        }
        if (!$id) {
            redirect(admin_url('public_weblinks'));
        }
        $response = $this->public_weblinks_model->delete_weblink($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('public_weblink')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('public_weblink')));
        }
        redirect(admin_url('public_weblinks'));
    }

   


    public function get_article_by_id_ajax($id)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->public_weblinks_model->get($id));
        }
    }
}
