<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Trust_accounting extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('trust_accounting_model');    
    }

    public function index()
    {
        $this->view();
    }

    public function view()
    {
        close_setup_menu();

        if (!has_permission('trust_accounting', '', 'view') && !has_permission('trust_accounting', '', 'view_own')) {
            access_denied('trust_accounting');
        }

        $this->load->model('currencies_model');
        $data['base_currency'] = $this->currencies_model->get_base_currency();
        $data['title']         = _l('trust_accounting');
        $data['trust_tab'] = !$this->input->get('trust_tab') ? 'trust_accounts' : $this->input->get('trust_tab');
        $res = $this->misc_model->_search_projects($q='',0,false,'tblprojects.id','DESC');
        $data['projects_'] = $res['result'];
        $this->load->view('admin/trust_accounting/trust_accounting', $data);
    }


    public function trust_account($id = '')
    {
        if (!is_admin() ) {
            access_denied('trust_accounting');
        }
        if ($this->input->post()) {
            if (!$this->input->post('id')) {
                $id = $this->trust_accounting_model->add_trust_account($this->input->post());
                if ($id) {
                    $success = true;
                    $message = _l('added_successfully', _l('trust_account'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message' => $message,
                    'id'=>$id,
                    'name'=>$this->input->post('name'),
                ));
            } else {
                $data = $this->input->post();
                $id   = $data['id'];
                unset($data['id']);
                $success = $this->trust_accounting_model->update_trust_account($data, $id);
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('trust_account'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message' => $message,
                ));
            }
        }
    }
     /* Delete announcement from database */
    public function delete_trust_account($id)
    {
        if (!$id) {
            redirect(admin_url('trust_accounting'));
        }
        $response = $this->trust_accounting_model->delete_trust_account($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('trust_account')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('trust_account')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('trust_account')));
        }
        redirect(admin_url('trust_accounting'));
    }
    public function table()
    {
        if (!has_permission('trust_accounting', '', 'view')
            && !has_permission('trust_accounting', '', 'view_own')) {
            ajax_access_denied();
        }
        $this->app->get_table_data('my_trust_accounts');
    }

     public function payee_table()
    {
        if (!has_permission('trust_accounting', '', 'view')
            && !has_permission('trust_accounting', '', 'view_own')) {
            ajax_access_denied();
        }
        $this->app->get_table_data('my_payees');
    }


    

    public function settings(){
        if($this->input->post()){
            $this->trust_accounting_model->update_options($this->input->post());
            set_alert('success', _l('updated_successfully', _l('settings')));
            redirect(admin_url('trust_accounting/view?trust_tab=settings'));

        }
    }


    public function payee($id = '')
    {
        if (!is_admin() ) {
            access_denied('trust_accounting');
        }
        if ($this->input->post()) {
            if (!$this->input->post('id')) {
                $id = $this->trust_accounting_model->add_payee($this->input->post());
                if ($id) {
                    $success = true;
                    $message = _l('added_successfully', _l('payee'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message' => $message,
                    'id'=>$id,
                    'name'=>$this->input->post('payee_name'),
                ));
            } else {
                $data = $this->input->post();
                $id   = $data['id'];
                unset($data['id']);
                $success = $this->trust_accounting_model->update_payee($data, $id);
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('payee'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message' => $message,
                ));
            }
        }
    }

     /* Delete announcement from database */
    public function delete_payee($id)
    {
        if (!$id) {
            redirect(admin_url('trust_accounting/view?trust_tab=payee_list'));
        }
        $response = $this->trust_accounting_model->delete_payee($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('payee')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('payee')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('payee')));
        }
        redirect(admin_url('trust_accounting/view?trust_tab=payee_list'));
    }
    
    
}
