<?php

defined('BASEPATH') or exit('No direct script access allowed');
function get_lead_client_types(){
    return array(array('id'=>'Company','name'=>'Company'),
                array('id'=>'Individual','name'=>'Individual'),
                array('id'=>'third_party','name'=>'Third Party')               
             );
}
function get_courtorder_type_name($id){
    $CI = &get_instance();

    if($id){
        return  $CI->db->get_where('tblcourt_ordernames',array('id'=>$id))->row()->name;
    }
}
function get_settlement_type(){
    return array(array('id'=>'onetime','name'=>'One Time'),
                array('id'=>'installment','name'=>'Installment'),
                 array('id'=>'nonsettle','name'=>'Non Settlement'),
               
             );
}
function get_settlement_nature(){
    return array(array('id'=>'courtorder','name'=>'By Court Order'),
                array('id'=>'legaldept','name'=>'By Legal Department'),
                  array('id'=>'branch','name'=>'By Branch'),
               
             );
}
function get_position_name_by_id($id){
    $CI = &get_instance();

    if($id > 0){
      $row =    $CI->db->get_where('tblpartytypes',array('id'=>$id))->row();
      if($row)
        return $row->name;
      else
        return ''; 
    }
}

function get_expense_name_by_id($id){
    $CI = &get_instance();

    if($id > 0){
      $row =    $CI->db->get_where('tblexpenses',array('id'=>$id))->row();
      if($row)
        return $row->expense_name;
      else
        return ''; 
    }
}
function get_trust_account_name_by_id($id){
    $CI = &get_instance();

    if($id > 0){
      $row =    $CI->db->get_where('tbltrust_accounts',array('id'=>$id))->row();
      if($row)
        return $row->trust_account_name;
      else
        return ''; 
    }
}
function get_payee_name_by_id($id){
    $CI = &get_instance();

    if($id > 0){
      $row =    $CI->db->get_where('tblpayee',array('id'=>$id))->row();
      if($row)
        return $row->payee_name;
      else
        return ''; 
    }
}
function get_trust_account_id($id){
    $CI = &get_instance();
    if($id){
      $row =    $CI->db->get_where('tblclients',array('userid'=>$id))->row();
      if($row)
        return $row->trust_account_id;
      else
        return 0; 
    }
}

function get_trust_accounts()
{
   $CI = &get_instance();
   return  $CI->db->select('tbltrust_accounts.*')->from('tbltrust_accounts')->where('active',1)->get()->result_array(); 
}

function get_payees()
{
   $CI = &get_instance();
   return  $CI->db->select('tblpayee.*')->from('tblpayee')->get()->result_array(); 
}
function get_case_client_types(){

    
    $CI = &get_instance();
    return  $CI->db->select('*')->from('tblproject_types')->where('active',1)->get()->result_array(); 
    /*return array( 
            array('id'=>'court_case','name'=>_l('court_case'),'type'=>'litigation'),
            array('id'=>'arbitration','name'=>_l('arbitration'),'type'=>'litigation'),
            array('id'=>'difc','name'=>_l('difc'),'type'=>'litigation'),
            if($_SERVER['SERVER_NAME'] != 'alowais.beveroncloud.com'){
                array('id'=>'legal_consultancy','name'=>_l('legal_consultancy'),'type'=>'nonlitigation'),
            }
            array('id'=>'drafting_contracts','name'=>_l('drafting_contracts'),'type'=>'nonlitigation'),
            array('id'=>'review','name'=>_l('review'),'type'=>'nonlitigation'),
            array('id'=>'legal_notice','name'=>_l('legal_notice'),'type'=>'nonlitigation'),
            array('id'=>'other_projects','name'=>_l('other_projects'),'type'=>'nonlitigation'),
        );*/
}
function get_payment_schedule_by_id($id){
    $CI = &get_instance();

    if($id){
      $row =    $CI->db->get_where('tblpayment_schedules',array('id'=>$id))->row();
      if($row)
        return $row->p_description.'-'.$row->p_amount;
      else
        return ''; 
    }
}
function create_slug($string){
   $slug=preg_replace('/[^A-Za-z0-9-]+/', '_', $string);
   return strtolower($slug);
}

function get_project_instances_added_for_project($id){
    $CI = &get_instance();
    if($id){
        $row =  $CI->db->select('tblproject_instances.*,tblproject_instances.instance_name as name')
                ->from('tblproject_instances')
                ->join('tblcase_details','tblproject_instances.id = tblcase_details.instance_id','inner')
                ->where('project_id',$id)
                ->get()->result_array();
        if($row)
            return $row;
        else
            return []; 
    }
}
function get_project_instances($type='')
{ 
    $CI = &get_instance();
 if($type=='')
    return  $CI->db->select('tblproject_instances.*,tblproject_instances.instance_name as name')->from('tblproject_instances')->get()->result_array(); 
 else
	return $CI->db->select('tblproject_instances.*,tblproject_instances.instance_name as name')->from('tblproject_instances')->where('type',$type)->get()->result_array(); 
}


function get_court_instance_name_by_id($id){
    $CI = &get_instance();

    if($id){
      $row =    $CI->db->get_where('tblproject_instances',array('id'=>$id))->row();
      if($row)
        return $row->instance_slug;
      else
        return ''; 
    }
}
function get_oppositeparty_by_customer($id){
    $CI = &get_instance();
    if($id){
      $row =  $CI->db->get_where('tblclient_oppositeparty_rel',array('client_id'=>$id))->result();
      if($row)
        return $row;
      else
        return ''; 
    }
}
function get_all_recovery_attachments($id,$type='corporate'){
    $CI = &get_instance();
    $CI->db->where('rel_id', $id);
    $CI->db->where('rel_type', $type);
    $client_main_attachments = $CI->db->get('tblfiles')->result_array();

    $attachments[$type] = $client_main_attachments;

    return $attachments;
}
function get_oppositeparty_profile_tabs($customer_id)
{
    $customer_tabs = array(
  array(
    'name'=>'profile',
    'url'=>admin_url('opposite_parties/opposite_party/'.$customer_id.'?group=profile'),
    'icon'=>'fa fa-user-circle',
    'lang'=>_l('debtor_add_edit_profile'),
    'visible'=>true,
    'order'=>1,
    ),
  array(
    'name'=>'notes',
    'url'=>admin_url('opposite_parties/opposite_party/'.$customer_id.'?group=notes'),
    'icon'=>'fa fa-sticky-note-o',
    'lang'=>_l('contracts_notes_tab'),
    'visible'=>true,
    'order'=>2,
    ),
   array(
    'name'=>'contacts',
    'url'=>admin_url('opposite_parties/opposite_party/'.$customer_id.'?group=contacts'),
    'icon'=>'fa fa-users menu-icon',
    'lang'=>_l('customer_contacts'),
    'visible'=>true,
    'order'=>3,
    ),
   array(
    'name'=>'casediary',
    'url'=>admin_url('opposite_parties/opposite_party/'.$customer_id.'?group=projects'),
    'icon'=>'fa fa-balance-scale menu-icon',
    'lang'=>_l('projects'),
    'visible'=>(has_permission('projects', '', 'view') || has_permission('projects', '', 'view_own')),
    'order'=>4,
    ),
  
  array(
    'name'=>'attachments',
    'url'=>admin_url('opposite_parties/opposite_party/'.$customer_id.'?group=attachments'),
    'icon'=>'fa fa-paperclip',
    'lang'=>_l('customer_attachments'),
    'visible'=>true,
    'order'=>16,
    ),
 
  array(
    'name'=>'reminders',
    'url'=>admin_url('opposite_parties/opposite_party/'.$customer_id.'?group=reminders'),
    'icon'=>'fa fa-clock-o',
    'lang'=>_l('client_reminders_tab'),
    'visible'=>true,
    'order'=>18,
    'id'=>'reminders',
    ),
 

  );


    usort($customer_tabs, function ($a, $b) {
        return $a['order'] - $b['order'];
    });

    return $customer_tabs;
}
function makeContractWord($contract_id){
    $CI = &get_instance();
    $CI->load->model('contracts_model');
    require_once  APPPATH . '/vendor/phpoffice/phpword/bootstrap.php';
    $contracts = $CI->contracts_model->get($contract_id);
    //if($proposal->proposal_format == 'defance_proposal_format'){
        $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor('temp/Bineid/Accident-Agreement.docx');
    //}
       
    $client_name = $contracts->company;
    $telephone = $contracts->phonenumber;
    $country = get_country($contracts->country);
    $emirates = $contracts->state;
    $contract_value = $contracts->contract_value;
    $datestart = $contracts->datestart;
    $subject = $contracts->subject;
    
    $templateProcessor->setValue('client_name', $client_name);
    $templateProcessor->setValue('telephone', $telephone);
    $templateProcessor->setValue('country',isset($country->short_name) ? $country->short_name :' ') ;
    $templateProcessor->setValue('emirates', $emirates);
    $templateProcessor->setValue('amount', $contract_value);
    $templateProcessor->setValue('date',date('d/m/Y',strtotime($datestart)));
    $templateProcessor->setValue('subject', $subject);

       
    $path  = get_upload_path_by_type('agreements').$contract_id.'/';
    _maybe_create_upload_path($path);

   /* $path  = get_upload_path_by_type('agreements').$contract_id.'/word/';
    _maybe_create_upload_path($path);*/

    if(file_exists($path.'Contract-Agreement.docx'))
            unlink($path.'Contract-Agreement.docx');
    $templateProcessor->saveAs($path.'Contract-Agreement.docx');
}

function get_staff_designation($id){
    $CI = &get_instance();

    if($id && $id != 0){
            return  $CI->db->get_where('tbldesignations',array('id'=>$id))->row()->name;

    }else{
        return ' ';
    }
}
function ideal_solutions_round_time($time_in_hours,$time_decimal)
{
    
    $in = floor($time_decimal);
    $hrs = explode(':',$time_in_hours);
    if($hrs[1] > 0){

        $CI = &get_instance();
        $ideal_ = $CI->db->get('tblbilling_increments_ideal_solutions')->result_array();

        foreach ($ideal_ as  $ideal) {
            if($hrs[1] >= $ideal['minute_from'] &&  $hrs[1] <= $ideal['minute_to']){
                $new_decimal = $ideal['billing_time'];
            }
        }
        if($hrs[1] >= 1 &&  $hrs[1] <= 6){
            $new_decimal = 1;
        }elseif($hrs[1] >= 7 &&  $hrs[1] <= 12){
            $new_decimal = 2;
        }elseif($hrs[1] >= 13 &&  $hrs[1] <= 18){
            $new_decimal = 3;
        }elseif($hrs[1] >= 19 &&  $hrs[1] <= 24){
            $new_decimal = 4;
        }elseif($hrs[1] >= 25 &&  $hrs[1] <= 30){
            $new_decimal = 5;
        }elseif($hrs[1] >= 31 &&  $hrs[1] <= 36){
            $new_decimal = 6;
        }elseif($hrs[1] >= 37 &&  $hrs[1] <= 42){
            $new_decimal = 7;
        }elseif($hrs[1] >= 43 &&  $hrs[1] <= 48){
            $new_decimal = 8;
        }elseif($hrs[1] >= 49 &&  $hrs[1] <= 54){
            $new_decimal = 9;
        }elseif($hrs[1] >= 55 &&  $hrs[1] <= 59){
            $new_decimal = 1;
        }

        return $in.'.'.$new_decimal;
    }

    return $time_decimal;
}
function get_casedetails_complete_update($project_id){
    $CI = &get_instance();
    $CI->db->select('content');
    $CI->db->where('rel_id', $project_id);
    $CI->db->where('rel_type', 'project');
    $case_details_qry = $CI->db->get('tblproject_updates');
    if($case_details_qry->num_rows() > 0){
        $result = $case_details_qry->result();
        $case_updates = '';
        foreach ($result as $row) {
            $case_updates .= html_entity_decode($row->content);
        }
        return $case_updates;
    }

    return '-';
}
function is_client_admin()
{
    $role = 2;
    $has_role = total_rows('tblstaff', 'role='.$role);

    return ($has_role > 0 ? true : false);
}

function customer_has_expense_deposit($customer_id)
{
    $CI = &get_instance();
    $totalCustomerDeposit = sum_from_table('tblinvoices',
                    array('field'=>'total',
                     'where' => array(
                            'clientid' => $customer_id,
                            'advance_invoice'=>'y'
                    )));

    $totalDeductedAmount = sum_from_table('tblexpenses',
                    array('field'=>'amount',
                     'where' => array(
                            'clientid' => $customer_id,
                            'deduct_from_advance'=>'y'
                    )));

    //$current_amount = $CI->db->get_where('tblclients',array('userid'=>$customer_id))->row()->current_expense_amount;

    $balance = $totalCustomerDeposit - $totalDeductedAmount;

    return ($balance >= 0 ? $balance  : false);
}

function update_customer_current_expense_deposit($customer_id,$amount,$action){
    $CI = &get_instance();
    $current_amount = $CI->db->get_where('tblclients',array('userid'=>$customer_id))->row()->current_expense_amount;

    if($action == 'add'){
        $new = $current_amount + $amount;
    }else{
        $new = $current_amount - $amount;
        if($new < 0) $new = 0;
    }
    $CI->db->where('userid',$customer_id);
    $CI->db->update('tblclients',array('current_expense_amount'=>$new));
}

function customer_expense_deposit_balance($customer_id)
{
    $CI = &get_instance();
    $totalCustomerDeposit = sum_from_table('tblinvoices',
                    array('field'=>'total',
                     'where' => array(
                        'clientid' => $customer_id,
                        'advance_invoice'=>'y'
                    )));

    $totalDeductedAmount = sum_from_table('tblexpenses',
                    array('field'=>'amount',
                     'where' => array(
                            'clientid' => $customer_id,
                            'deduct_from_advance'=>'y'
                    )));

    //$current_amount = $CI->db->get_where('tblclients',array('userid'=>$customer_id))->row()->current_expense_amount;

    $balance = $totalCustomerDeposit - $totalDeductedAmount;

    return number_format($balance,2);
}
function assign_all($assignded_ids,$rel_name,$rel_id)
{
    
    $CI = &get_instance();
    $all_old_assignees = get_all_assignees($rel_name,$rel_id);
    $old_assigned = array_column($all_old_assignees, 'assigneeid');
    //Delete old assigned staff ids
    $CI->db->where('rel_name',$rel_name);
    $CI->db->where('rel_id',$rel_id);
    $CI->db->delete('tblall_assignees');
    

    foreach ($assignded_ids as $key => $value) {
        $CI->db->insert('tblall_assignees', array(
                'rel_id' => $rel_id,
                'staff_id' => $value,
                'assigned_by'=>get_staff_user_id(),
                'rel_name'=>$rel_name,
                'dateadded'=>date('Y-m-d H:i:s')
            ));
        if($rel_name == 'lead'){
            $CI->load->model('leads_model');
            if(!in_array($value, $old_assigned)){
                if(get_option('create_lead_auto_reminder') == 1 ){
                    $CI->leads_model->create_auto_reminders($rel_id,$value);
                }
                $CI->leads_model->lead_assigned_member_notification($rel_id, $value);
            }
        }
    }
}

function get_all_assignees($rel_name,$rel_id)
{
    $CI = &get_instance();
    $CI->db->select('id,tblall_assignees.staff_id as assigneeid,assigned_by,firstname,lastname,CONCAT(firstname, " ", lastname) as full_name,is_lawyer,admin,dateadded');
        $CI->db->from('tblall_assignees');
        $CI->db->join('tblstaff', 'tblstaff.staffid = tblall_assignees.staff_id');
        $CI->db->where('rel_name', $rel_name );
        $CI->db->where('rel_id', $rel_id );
    return $CI->db->get()->result_array();
}
function get_project_files_attached($project_id){
    $CI = &get_instance();
    $CI->db->where('project_id', $project_id);
    $case_files_qry = $CI->db->get('tblproject_files');

    if($case_files_qry->num_rows() > 0){
        $files = $case_files_qry->result_array();
        $result = '<div class="row">
            <div class="col-md-12">
                <p class="text-uppercase bold text-dark font-medium">
                    '._l('project_files').'</p>
        <ol class="list-group">';
        foreach ($files as $file) {
            if(isset($file['subject'])){
                $result .= ' <li class="list-group-item"><a href="'.admin_url('projects/view/'.$project_id.'?group=project_files').'">'.$file['subject'].'</a></li>';    
            }
            
        }
       return  $result .= '</ul></div></div><hr>';
    }
}    
          
function get_case_latest_update($project_id,$dashboard=false){
    $CI = &get_instance();
    $CI->db->where('rel_id', $project_id);
    $CI->db->where('rel_type', 'project');
    $CI->db->limit(1);
    $CI->db->order_by('id','DESC');   
    $case_details_qry = $CI->db->get('tblproject_updates');

    if($case_details_qry->num_rows() > 0){
        $row = $case_details_qry->row();
        $type = 'Latest Update';
        $update = nl2br($row->content);
        if($dashboard)
            return $type.'^'.$row->content;
        else
            return '<div class="panel_s panel-info">
                     <div class="panel-body"><h4>Latest Update</h4>'.$update.'</div></div>';
                         

                    // return $type.' - '.$update;
    }

    return ' No updates ^';
}
function get_hearing_latest_update($project_id){
    $CI = &get_instance();
    $CI->db->where('project_id', $project_id);
    $CI->db->limit(1);
    $CI->db->order_by('id','DESC');   
    $case_details_qry = $CI->db->get('tblhearings');

    if($case_details_qry->num_rows() > 0){
        $row = $case_details_qry->row();
        $type = _l($row->hearing_type);
        $update = nl2br($row->proceedings);
        return '<div class="panel_s panel-info">
                     <div class="panel-body"><h4>'.$type.'</h4>'.$update.'</div></div>';
    }

    return ' ';
}
function getfirsthearingdate($project_id=''){
	$CI = &get_instance();
   // $CI->db->where('project_id', $project_id);
    $CI->db->limit(1);
    $CI->db->order_by('hearing_date','ASC');   
    $case_details_qry = $CI->db->get('tblhearings');

    if($case_details_qry->num_rows() > 0){
        $row = $case_details_qry->row();
         $update = DATE($row->hearing_date);
        return $update;
    }

    return ' ';
}

function get_case_final_statuses(){
    return array(
        array('id'=>'dismissed','name'=>'Dismissed'),
        array('id'=>'won','name'=>'Won'),
        array('id'=>'failure','name'=>'Failure'),
    );
}
function get_proposal_formats(){
    return array(
        array('id'=>'defance_proposal_format','name'=>'Defance Proposal Format'),
        array('id'=>'arbitration_proposal_format','name'=>'Arbitration Proposal Format'),
        array('id'=>'legal_proposal_format_with_kbo','name'=>'Legal Proposal Format With KBO'),
        array('id'=>'legal_proposal_format_with_nm','name'=>'Legal Proposal Format With NM'),
    );
}
function get_all_lawyers_attachments($id){
    $CI = &get_instance();
    $CI->db->where('rel_id', $id);
    $CI->db->where('rel_type', 'lawyer');
    $client_main_attachments = $CI->db->get('tblfiles')->result_array();

    $attachments['lawyer'] = $client_main_attachments;

    return $attachments;
}
/**
 * Return contact profile image url
 * @param  mixed $contact_id
 * @param  string $type
 * @return string
 */
function lawyer_profile_image_url($contact_id, $type = 'small')
{
    
    $url = base_url('assets/images/user-placeholder.jpg');
    $CI =& get_instance();
    $CI->db->select('profile_image');
    $CI->db->from('tbllawyers');
    $CI->db->where('lawyerid', $contact_id);
    $contact = $CI->db->get()->row();
    
    if ($contact) {
        if (!empty($contact->profile_image)) {
            $path = 'uploads/lawyer_profile_images/' . $contact_id . '/' . $type . '_' . $contact->profile_image;
            if (file_exists($path)) {
                $url = base_url($path);
            }
        }
    }

    return $url;
}
/**
 * Get predefined tabs array, used in customer profile
 * @param  mixed $customer_id customer id to prepare the urls
 * @return array
 */
function get_lawyers_profile_tabs($customer_id)
{
    $customer_tabs = array(
  array(
    'name'=>'profile',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=profile'),
    'icon'=>'fa fa-user-circle',
    'lang'=>_l('lawyer_add_edit_profile'),
    'visible'=>true,
    'order'=>1,
    ),
  array(
    'name'=>'notes',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=notes'),
    'icon'=>'fa fa-sticky-note-o',
    'lang'=>_l('contracts_notes_tab'),
    'visible'=>true,
    'order'=>2,
    ),
  array(
    'name'=>'statement',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=statement'),
    'icon'=>'fa fa-area-chart',
    'lang'=>_l('customer_statement'),
    //'visible'=>(has_permission('invoices', '', 'view') && has_permission('payments', '', 'view')),
    'order'=>3,
    'visible'=>false,
    ),
  array(
    'name'=>'invoices',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=invoices'),
    'icon'=>'fa fa-file-text',
    'lang'=>_l('lawyer_invoices_tab'),
    //'visible'=>(has_permission('invoices', '', 'view') || has_permission('invoices', '', 'view_own')),
    'order'=>4,'visible'=>false,
    ),
  array(
    'name'=>'payments',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=payments'),
    'icon'=>'fa fa-line-chart',
    'lang'=>_l('lawyer_payments_tab'),
    //'visible'=>(has_permission('payments', '', 'view') || has_permission('invoices', '', 'view_own')),
    'order'=>5,
    'visible'=>false,
    ),
   array(
    'name'=>'receipts',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=receipts'),
    'icon'=>'fa fa-money',
    'lang'=>_l('lawyer_receipts_tab'),
    //'visible'=>(has_permission('payments', '', 'view') || has_permission('invoices', '', 'view_own')),
    'order'=>5,
    'visible'=>false,
    ),
  array(
    'name'=>'proposals',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=proposals'),
    'icon'=>'fa fa-file-powerpoint-o',
    'lang'=>_l('proposals'),
   // 'visible'=>(has_permission('proposals', '', 'view') || has_permission('proposals', '', 'view_own') || (get_option('allow_staff_view_proposals_assigned') == 1 && total_rows('tblproposals', array('assigned'=>get_staff_user_id())) > 0)),
    'order'=>6,
    'visible'=>false,
    ),
    array(
    'name'=>'credit_notes',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=credit_notes'),
    'icon'=>'fa fa-sticky-note-o',
    'lang'=>_l('credit_notes'),
   // 'visible'=>(has_permission('credit_notes', '', 'view') || has_permission('credit_notes', '', 'view_own')),
    'order'=>7,
    'visible'=>false,
    ),
  array(
    'name'=>'estimates',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=estimates'),
    'icon'=>'fa fa-clipboard',
    'lang'=>_l('estimates'),
   // 'visible'=>(has_permission('estimates', '', 'view') || has_permission('estimates', '', 'view_own')),
    'order'=>8,
    'visible'=>false,
    ),
  array(
    'name'=>'expenses',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=expenses'),
    'icon'=>'fa fa-file-text-o',
    'lang'=>_l('expenses'),
    'visible'=>(has_permission('expenses', '', 'view') || has_permission('expenses', '', 'view_own')),
    'order'=>9,
    
    ),
  /*array(
    'name'=>'contracts',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=contracts'),
    'icon'=>'fa fa-floppy-o',
    'lang'=>_l('contracts'),
    'visible'=>(has_permission('contracts', '', 'view') || has_permission('contracts', '', 'view_own')),
    'order'=>10,
    ),*/
   array(
    'name'=>'documents',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=documents'),
    'icon'=>'fa fa-file',
    'lang'=>_l('documents'),
    //'visible'=>(has_permission('documents', '', 'view') || has_permission('documents', '', 'view_own')),
    'order'=>11,
    'visible'=>false,

    ),
  
  array(
    'name'=>'projects',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=projects'),
    'icon'=>'fa fa-bars',
    'lang'=>_l('projects'),
    'visible'=>true,
    'order'=>13,
    ),
    array(
    'name'=>'tasks',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=tasks'),
    'icon'=>'fa fa-tasks',
    'lang'=>_l('tasks'),
    'visible'=>false,
    'order'=>14,
    ),
  /*array(
    'name'=>'tickets',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=tickets'),
    'icon'=>'fa fa-ticket',
    'lang'=>_l('tickets'),
    'visible'=>((get_option('access_tickets_to_none_staff_members') == 1 && !is_staff_member()) || is_staff_member()),
    'order'=>15,
    ),*/
  array(
    'name'=>'attachments',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=attachments'),
    'icon'=>'fa fa-paperclip',
    'lang'=>_l('customer_attachments'),
    'visible'=>true,
    'order'=>16,
    ),
  /*array(
    'name'=>'vault',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=vault'),
    'icon'=>'fa fa-lock',
    'lang'=>_l('vault'),
    'visible'=>true,
    'order'=>17,
    ),*/
  array(
    'name'=>'reminders',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=reminders'),
    'icon'=>'fa fa-clock-o',
    'lang'=>_l('lawyer_reminders_tab'),
    'visible'=>false,
    'order'=>18,
    'id'=>'reminders',

    ),
  array(
    'name'=>'map',
    'url'=>admin_url('lawyers/lawyer/'.$customer_id.'?group=map'),
    'icon'=>'fa fa-map-marker',
    'lang'=>_l('customer_map'),
    'visible'=>false,
    'order'=>19,
    ),

  );

    $hook_data = hooks()->apply_filters('customer_profile_tabs', array('tabs'=>$customer_tabs, 'customer_id'=>$customer_id));
    $customer_tabs = $hook_data['tabs'];

    usort($customer_tabs, function ($a, $b) {
        return $a['order'] - $b['order'];
    });

    return $customer_tabs;
}
function get_nature_of_case_by_id($id,$for='dashboard'){
    $CI = &get_instance();

    if($id && $id != 0){
        if($for == 'dashboard'){
            return  ' |<b> '.$CI->db->get_where('tblcase_natures',array('id'=>$id))->row()->name.'</b>';
        }else{
            return  $CI->db->get_where('tblcase_natures',array('id'=>$id))->row()->name;
        } 
    }else{
        return ' ';
    }
}
/**
 * Load invoices total templates
 * This is the template where is showing the panels Outstanding Invoices, Paid Invoices and Past Due invoices
 * @return string
 */
function my_load_project_invoices_total_template()
{
    $CI = &get_instance();
    $CI->load->model('invoices_model');
    $_data = $CI->input->post();
    if (!$CI->input->post('customer_id')) {
        $multiple_currencies = call_user_func('is_using_multiple_currencies');
    } else {
        $_data['customer_id'] = $CI->input->post('customer_id');
        $multiple_currencies  = call_user_func('is_client_using_multiple_currencies', $CI->input->post('customer_id'));
    }

    if ($CI->input->post('project_id')) {
        $_data['project_id'] = $CI->input->post('project_id');
    }

    if ($multiple_currencies) {
        $CI->load->model('currencies_model');
        $data['invoices_total_currencies'] = $CI->currencies_model->get();
    }

    $data['invoices_years'] = $CI->invoices_model->get_invoices_years();

    if (
        count($data['invoices_years']) >= 1
        && !\app\services\utilities\Arr::inMultidimensional($data['invoices_years'], 'year', date('Y'))
    ) {
        array_unshift($data['invoices_years'], ['year' => date('Y')]);
    }
        $CI->load->model('projects_model');

    $data['project_cost'] = $CI->db->get_where('tblprojects',array('id'=>$_data['project_id']))->row()->project_cost;
    $data['total_result'] = $CI->invoices_model->get_invoices_total($_data);
    $data['_currency']    = $data['total_result']['currencyid'];

    $CI->load->view('admin/projects/my_projects_invoices_total_template', $data);
}
function get_debt_collection_status_(){
    return array(
          array('id'=>'submitted','name'=>'Submitted'),
          array('id'=>'finance_confirmed','name'=>'Finance Confirmed'),
          array('id'=>'debt_collection','name'=>'Debt Collection'),
          array('id'=>'legal','name'=>'Legal'),
          array('id'=>'closed','name'=>'Closed')
      );
}

function get_emirates(){
    return array(
            array('id'=>'Abu Dhabi','name'=>'Abu Dhabi','code'=>'Abu Dhabi-ADB'),
            array('id'=>'Dubai','name'=>'Dubai','code'=>'Dubai-DXB'),
            array('id'=>'Sharjah','name'=>'Sharjah','code'=>'Sharjah-SHJ'),
            array('id'=>'Ajman','name'=>'Ajman','code'=>'Ajman-AJM'),
            array('id'=>'Umm Al-Quwain','name'=>'Umm Al-Quwain','code'=>'Umm Al Quwain-UAQ'),
            array('id'=>'Fujairah','name'=>'Fujairah','code'=>'Fujairah-FUJ'),
            array('id'=>'Ras Al Khaimah','name'=>'Ras Al Khaimah','code'=>'Ras Al Khaimah-RAK'),
        );
}
function get_client_positions(){
   /* return array(
            array('id'=>'defendant','name'=>'Defendant-المدعى عليه'),
            array('id'=>'plaintiff','name'=>'Plaintiff - مدعي  '),
            array('id'=>'petitioner','name'=>'Petitioner -  الملتمس,   '),
            array('id'=>'witness','name'=>"Witness - شاهد  "),
            array('id'=>'challenger','name'=>"Challenger -  المعترض  "),
            array('id'=>'challenged','name'=>"Challenged - المعترض عليه "),
            array('id'=>'claimant','name'=>"Claimant - المحتكمة "),
            array('id'=>'respondent','name'=>"Respondent -  المحتكم ضدها "),
            array('id'=>'applicant','name'=>"Applicant - الطالب"),
            array('id'=>'complainant','name'=>"Complainant -  المشتكي "),
            array('id'=>'accused','name'=>"Accused - المتهم "),

        );*/
    $CI = &get_instance();
    $CI->load->model('partytype_model');
    return $CI->partytype_model->get();
}
function get_hearing_types(){
    return array(
        array('id'=>'first_instance','name'=>_l('first_instance')),
        array('id'=>'appeal','name'=>_l('appeal')),
        array('id'=>'appeal_opposite','name'=>_l('appeal_opposite')),
        array('id'=>'cassation','name'=>_l('cassation')),
        array('id'=>'execution','name'=>_l('execution')),
        array('id'=>'execution_appeal','name'=>_l('execution_appeal')),
        array('id'=>'small_claim','name'=>_l('small_claim')),
        array('id'=>'partial_commercial_claim','name'=>_l('partial_commercial_claim')),
        array('id'=>'commercial_claim','name'=>_l('commercial_claim')),
        array('id'=>'legal_warnings','name'=>_l('legal_warnings')),
        array('id'=>'advertisement','name'=>_l('advertisement')),
        array('id'=>'judgement','name'=>_l('judgement')) ,
        array('id'=>'expert_committee','name'=>_l('expert_committee')) ,
        array('id'=>'criminal','name'=>_l('criminal')) , 
    );
}

// Templates

/**
 * Default project tabs
 * @param  mixed $project_id project id to format the url
 * @return array
 */
function get_templates_tabs_admin($project_id)
{
    $project_tabs = array(
    array(
        'name'=>'case_overview',
        'url'=>admin_url('casetemplates/view/'.$project_id.'?group=case_overview'),
        'icon'=>'fa fa-th',
        'lang'=>_l('case_overview'),
        'visible'=>true,
        'order'=>1,
        ),
    array(
        'name'=>'scope',
        'url'=>admin_url('casetemplates/view/'.$project_id.'?group=scope'),
        'icon'=>'fa fa-balance-scale',
        'lang'=>_l('scope'),
        'visible'=>true,
        'order'=>2,
        ),
    array(
        'name'=>'project_tasks',
        'url'=>admin_url('casetemplates/view/'.$project_id.'?group=project_tasks'),
        'icon'=>'fa fa-check-circle',
        'lang'=>_l('tasks'),
        'visible'=>true,
        'order'=>3,
        'linked_to_customer_option'=>array('view_tasks'),
        ),
    array(
        'name'=>'document_checklists',
        'url'=>admin_url('casetemplates/view/'.$project_id.'?group=document_checklists'),
        'icon'=>'fa fa-rocket',
        'lang'=>_l('document_checklists'),
        'visible'=>false,
        'order'=>4,
        'linked_to_customer_option'=>array('view_documents'),
        ),
    
    /*array(
        'name'=>'project_milestones',
        'url'=>admin_url('casetemplates/view/'.$project_id.'?group=project_milestones'),
        'icon'=>'fa fa-rocket',
        'lang'=>_l('project_milestones'),
        'visible'=>false,
        'order'=>5,
        'linked_to_customer_option'=>array('view_milestones'),
        ),*/
    );

    //$project_tabs = hooks()->apply_filters('project_tabs_admin', $project_tabs);

    usort($project_tabs, function ($a, $b) {
        return $a['order'] - $b['order'];
    });

    return $project_tabs;
}

function init_relation_tasks_templates_table($table_attributes = array())
{
    $table_data = array(
        array(
            'name'=>_l('tasks_dt_name'),
            'th_attrs'=>array(
                'style'=>'min-width:200px',
                ),
            ),
         array(
            'name'=>_l('tasks_dt_datestart'),
            'th_attrs'=>array(
                'style'=>'min-width:75px',
                'class'=>'not_visible',
                ),
            ),
         array(
            'name'=>_l('task_duedate'),
            'th_attrs'=>array(
                'style'=>'min-width:75px',
                'class'=>'duedate not_visible',

                ),
            ),

         array(
            'name'=>_l('tags'),
            'th_attrs'=>array(
                'class'=>'duedate not_visible',

                ),
            ),
        _l('task_add_edit_description'),
        _l('task_status'),
    );

   

    $custom_fields = get_custom_fields('tasks', array(
        'show_on_table' => 1,
    ));

    foreach ($custom_fields as $field) {
        array_push($table_data, $field['name']);
    }

    //$table_data = hooks()->apply_filters('tasks_related_table_columns', $table_data);

    array_push($table_data, array('name'=>_l('options'), 'th_attrs'=>array('class'=>'table-tasks-options')));

    $name = 'rel-tasks';
    if ($table_attributes['data-new-rel-type'] == 'lead') {
        $name = 'rel-tasks-leads';
    }if ($table_attributes['data-new-rel-type'] == 'defaulter') {
        $name = 'rel-tasks-defaulter';
    }

    $table = '';
    $CI =& get_instance();
    $table_name = '.table-' . $name;
    /*$CI->load->view('admin/tasks/tasks_filter_by', array(
        'view_table_name' => $table_name,
    ));*/
    if (has_permission('tasks', '', 'create')) {
        $disabled   = '';
        $table_name = addslashes($table_name);
        if ($table_attributes['data-new-rel-type'] == 'customer' && is_numeric($table_attributes['data-new-rel-id'])) {
            if (total_rows('tblclients', array(
                'active' => 0,
                'userid' => $table_attributes['data-new-rel-id'],
            )) > 0) {
                $disabled = ' disabled';
            }
        }
        /*if ($table_attributes['data-new-rel-type'] == 'defaulter' && is_numeric($table_attributes['data-new-rel-id'])) {
            if (total_rows('tbldefaulters', array(
                'active' => 0,
                'id' => $table_attributes['data-new-rel-id'],
            )) > 0) {
                $disabled = ' disabled';
            }
        }*/
        /*if($table_attributes['data-new-rel-type'] == 'casediary'){
            $new_task_label = 'new_action';
        }else{*/
            $new_task_label = 'new_task';
        //}
        // projects have button on top
        
        echo "<a href='#' class='btn btn-info pull-left mbot25 mright5 new-task-relation" . $disabled . "' onclick=\"new_template_task_from_relation('$table_name'); return false;\" data-rel-id='".$table_attributes['data-new-rel-id']."' data-rel-type='".$table_attributes['data-new-rel-type']."'>" . _l($new_task_label) . "</a>";
        
        

    }
    echo "<div class='clearfix'></div>";
    $table .= render_datatable($table_data, $name, array(), $table_attributes);

    return $table;
}
function get_document_masters(){
    $CI =& get_instance();
    $documentmaster = $CI->db->get('tbldocumentmaster')->result_array();
    if ($documentmaster) {
        return $documentmaster;
    }

    return array();
}

function get_document_master_name($id){
    $CI = &get_instance();

    if($id){
        return  $CI->db->get_where('tbldocumentmaster',array('id'=>$id))->row()->name;
    }
}

function get_opposite_party_name($id){
    $CI = &get_instance();

    if($id){
      $row =    $CI->db->get_where('tbloppositeparty',array('id'=>$id))->row();
      if($row)
        return $row->name;
      else
        return '-'; 
    }
}
function get_opposite_party_trade_license($id){
    $CI = &get_instance();

    if($id){
      $row =    $CI->db->get_where('tbloppositeparty',array('id'=>$id))->row();
      if($row)
        return $row->trade_license_no;
      else
        return '-'; 
    }
}


function get_case_templates($casetype='')
{
    $CI =& get_instance();
    if($casetype!= '')
    $CI->db->where('case_type', $casetype);
    $project = $CI->db->get('tblcasetemplates')->result_array();
    if ($project) {
        return $project;
    }

    return [];
}

function template_data_transfer($matterid,$templateid,$related='project'){

        // Copy Scopes
        $CI =& get_instance();

        if($related == 'project'){
             $scopes = $CI->db->get_where('tblcasetemplate_scopes',array('casetemplate_id'=>$templateid))->result();
            foreach ($scopes as $scope) {
                $data['scope_description'] = $scope->scope_description;
                $data['case_id']  = $matterid;
                $CI->db->insert('tblcase_scopes',$data);
            }
        }

        // Get Tasks in the milestones
        $tasks = $CI->db->get_where('tblstafftasks_templates',array('rel_id'=>$templateid,'rel_type'=>'casetemplates'))->result_array();
            foreach ($tasks as $task) {
                $cur_task_id = $task['id'];
                $task['milestone'] = 0;
                $task['rel_id'] = $matterid;
                $task['rel_type'] = $related;
                $task['startdate'] = date('Y-m-d H:i:s');
                $task['duedate'] = NULL;
                if($task['repeat_every'] !='' && $task['repeat_every'] !=NULL ){
                    $task['repeat_every']   = $task['repeat_every'].'-'.$task['recurring_type'];
                }
                if($task['due_days'] > 0){
                    $task['duedate'] = _d(date('Y-m-d H:i:s',strtotime($task['startdate'].'+ '.$task['due_days'].' days')));
                }
                $CI->load->model('tasks_model');
                unset($task['id']);
                unset($task['due_days']);
                unset($task['create_auto_reminder']);
                unset($task['auto_reminder_hours']);
                unset($task['auto_reminder_description']);

                /*unset($task['repeat_every']);
                unset($task['repeat_type_custom']);*/
                $task_id = $CI->tasks_model->add($task);

                if($related == 'lead' || $related == 'customer'){
                    /*$assignded_ids = get_all_assignees('lead',$matterid);
                    foreach ($assignded_ids as $value) {
                        $assign_task['taskid'] = $task_id;
                        $assign_task['assignee'] = $value['assigneeid'];
                        $CI->tasks_model->add_task_assignees($assign_task);
                    }*/

                    $assigned_ids = json_decode(get_option('auto_assign_staffs'),true);
                    foreach ($assigned_ids as $value) {
                        $assign_task['taskid'] = $task_id;
                        $assign_task['assignee'] = $value;
                        $CI->tasks_model->add_task_assignees($assign_task);
                    }
                    
                }
            }

         if($related == 'project'){    
            // Documnt master
            $document_masters = $CI->db->get_where('tblcasetemplates',array('id'=>$templateid))->row()->document_checklists;
            $document_masters = explode(',', $document_masters);

            foreach ($document_masters as $doc) {
               /* $d_data['case_id'] = $matterid;
                $d_data['dateadded'] = date('Y-m-d H:i:s');
                $d_data['added_by'] = get_staff_user_id();
                $d_data['document_checklists_id'] = $doc;
                $d_data['name'] = get_document_master_name($doc);
                $this->db->insert('tblcase_documentmaster',$d_data);*/

                $data2 = array(
                    'project_id' => $matterid,
                    'file_name' => '',
                    'filetype' => '',
                    'dateadded' => date('Y-m-d H:i:s'),
                    'staffid' =>get_staff_user_id(),
                    'contact_id' => 0,
                    'subject' => get_document_master_name($doc),
                    'visible_to_customer' =>0,
                    'document_master_id' =>$doc,
                );
                $CI->db->insert('tblproject_files', $data2);
            } 
        }
    }

function get_proposal_types(){
    return array(
            array('id'=>'fee_proposal_without_loe','name'=>'Fee Proposal without LoE'),
            array('id'=>'fee_proposal_with_loe','name'=>'Fee Proposal with LoE'),
            array('id'=>'loe','name'=>'LoE'),
            array('id'=>'offer_letter_for_retainer_contract','name'=>'Offer Letter for Retainer Contract'),
            array('id'=>'retainer_contract','name'=>'Retainer Contract'),
        );
}
function get_matter_template_name_by_id($id)
{
    $CI =& get_instance();
    $CI->db->select('name');
    $CI->db->where('id', $id);
    $project = $CI->db->get('tblcasetemplates')->row();

    if ($project) {
        return $project->name;
    }
    return '';
}

function get_proposal_fee_statuses(){
    $CI = &get_instance();
    return $CI->db->get('tblproposal_fee_status')->result();

}

function get_table_items_and_taxes_fee_proposal($items, $type, $admin_preview,$table,$myFontStyle)
{
    $cf = count($items) > 0 ? get_items_custom_fields_for_table_html($items[0]['rel_id'], $type) : array();

    static $rel_data = null;

    $result['html']    = '';
    $result['taxes']   = array();
    $_calculated_taxes = array();
    $i                 = 1;
    foreach ($items as $item) {
        $_item             = '';
        $tr_attrs       = '';
        $td_first_sortable = '';

        if ($admin_preview == true) {
            $tr_attrs       = '';//' class="sortable" data-item-id="' . $item['id'] . '"';
            $td_first_sortable = '';//' class="dragger item_no"';
        }

        $align_center =  ['align' => 'center'];
        $align_right =  ['align' => 'right'];
        
        $align_left =  ['align' => 'left'];
        $myFontStyle2 = [
            'name' => 'Comic Sans MS',
            'size' => '10',
            'color' => '000080',
            'bold' => false,
            //'italic' => true
        ];
        $amount_column_align = array(
            //'space' => array('before' => 360, 'after' => 280), 
            'indentation' => array('left' => 580, 'right' => 80)
        );
        $table->addRow();
        $table->addCell()->addText($i,$myFontStyle,$align_center);
        $itemCell  = $table->addCell();
        $itemCell->addText($item['description'],$myFontStyle,$align_left);
        $itemCell->addText($item['long_description'],$myFontStyle2,$align_left);
        $table->addCell()->addText(floatVal($item['qty']),$myFontStyle,$align_center);
        $table->addCell()->addText(_format_number($item['rate']),$myFontStyle,$align_center);

       

        $_item .= '</td>';
        $_item .= '<td align="right">' . _format_number($item['rate']) . '</td>';
        if (get_option('show_tax_per_item') == 1) {
            $_item .= '<td align="right">';
        }

        $item_taxes = array();

        // Separate functions exists to get item taxes for Invoice, Estimate, Proposal, Credit Note
        $func_taxes = 'get_'.$type.'_item_taxes';
        if (function_exists($func_taxes)) {
            $item_taxes = call_user_func($func_taxes, $item['id']);
        }
        $_item2 = '';
        if (count($item_taxes) > 0) {

            if (!$rel_data) {
                $rel_data = get_relation_data($item['rel_type'], $item['rel_id']);
            }

            foreach ($item_taxes as $tax) {
                $calc_tax     = 0;
                $tax_not_calc = false;
                if (!in_array($tax['taxname'], $_calculated_taxes)) {
                    array_push($_calculated_taxes, $tax['taxname']);
                    $tax_not_calc = true;
                }
                if ($tax_not_calc == true) {
                    $result['taxes'][$tax['taxname']]          = array();
                    $result['taxes'][$tax['taxname']]['total'] = array();
                    array_push($result['taxes'][$tax['taxname']]['total'], (($item['qty'] * $item['rate']) / 100 * $tax['taxrate']));
                    $result['taxes'][$tax['taxname']]['tax_name'] = $tax['taxname'];
                    $result['taxes'][$tax['taxname']]['taxrate']  = $tax['taxrate'];
                } else {
                    array_push($result['taxes'][$tax['taxname']]['total'], (($item['qty'] * $item['rate']) / 100 * $tax['taxrate']));
                }
                if (get_option('show_tax_per_item') == 1) {
                    $item_tax = '';
                    if ((count($item_taxes) > 1 && get_option('remove_tax_name_from_item_table') == false) || get_option('remove_tax_name_from_item_table') == false || mutiple_taxes_found_for_item($item_taxes)) {
                        $tmp = explode('|', $tax['taxname']);
                        $item_tax = $tmp[0] . ' ' . _format_number($tmp[1]) . '%<br />';
                    } else {
                        $item_tax = _format_number($tax['taxrate']) . '%';
                    }
                    $hook_data = array('final_tax_html'=>$item_tax, 'item_taxes'=>$item_taxes, 'item_id'=>$item['id']);
                    $hook_data = hooks()->apply_filters('item_tax_table_row', $hook_data);
                    $item_tax .= $hook_data['final_tax_html'];
                }
            }
        } else {
            if (get_option('show_tax_per_item') == 1) {
                $hook_data = array('final_tax_html'=>'0%', 'item_taxes'=>$item_taxes, 'item_id'=>$item['id']);
                $hook_data = hooks()->apply_filters('item_tax_table_row', $hook_data);
                $item_tax = $hook_data['final_tax_html'];
            }
        }

        if (get_option('show_tax_per_item') == 1) {
            //$table->addCell()->addText(floatVal($item_tax),$myFontStyle,$align_center);
        }

        /**
         * Since @version 1.7.0
         * Possible action hook user to include tax in item total amount calculated with the quantiy
         * eq Rate * QTY + TAXES APPLIED
         */

        //$tax_value = (($item['rate'] * $item['qty'])-$total_dis_calculated)*($item_tax/100);
        $hook_data = hooks()->apply_filters('final_item_amount', array(
            'amount'=>($item['qty'] * $item['rate']),
            'item_taxes'=>$item_taxes,
            'item'=>$item,
        ));

        $item_amount_with_quantity = _format_number($hook_data['amount']);

        $_item .= '<td class="amount" align="right">' . $item_amount_with_quantity . '</td>';
        $table->addCell()->addText($item_amount_with_quantity,$myFontStyle,$amount_column_align);

        $_item .= '</tr>';
        $result['html'] .= $_item;
        $i++;
    }

        /*foreach ($result['taxes'] as $tax) {

            $total_tax = array_sum($tax['total']);
            if ($rel_data->discount_percent != 0 && $rel_data->discount_type == 'before_tax') {
                $total_tax_tax_calculated = ($total_tax * $rel_data->discount_percent) / 100;
                $total_tax = ($total_tax - $total_tax_tax_calculated);
            } elseif ($rel_data->discount_total != 0 && $rel_data->discount_type == 'before_tax') {
                $t = ($rel_data->discount_total / $rel_data->subtotal) * 100;
                $total_tax = ($total_tax - $total_tax*$t/100);
            }

            $result['taxes'][$tax['tax_name']]['total_tax'] = $total_tax;
            // Tax name is in format NAME|PERCENT
            $tax_name_array = explode('|', $tax['tax_name']);
            $result['taxes'][$tax['tax_name']]['taxname'] = $tax_name_array[0];
        }*/

        ///return hooks()->apply_filters('before_return_table_items_html_and_taxes', $result);
    } 
function get_document_type_name($id){
    $CI = &get_instance();

    if($id){
        return  $CI->db->get_where('tbldocument_types',array('id'=>$id))->row()->name;
    }
}


function get_court_name($userid = '')
{
    $CI = &get_instance();

    if(is_numeric($userid) && $userid != 0){
        return  $CI->db->get_where('tblcourts',array('id'=>$userid))->row()->name;
    }
    return '';
}
function get_kyc_checkstatus(){
    return array(
          array('id'=>'yes','name'=>'Yes'),
          array('id'=>'no','name'=>'No'),
        );
}
function get_kycdocument_type_name($id){
    $CI = &get_instance();

    if($id){
        return  $CI->db->get_where('tblkycdocuments',array('id'=>$id))->row()->name;
    }
}
function get_party_name($userid)
{
    
    $CI =& get_instance();

    $client = $CI->db->select('name')
    ->where('id', $userid)
    ->from('tbloppositeparty')
    ->get()
    ->row();
    if ($client) {
        return $client->name;
    } else {
        return '';
    }
}
function get_court_types(){
    return array(
        array('id'=>'litigation','name'=>'Litigation'),
        array('id'=>'arbitration','name'=>'Arbitration'),
      
    );
}
/* For Multiple clients*/
function get_all_extraclients($rel_id='')
{
    $CI = &get_instance();
    $CI->db->select('id,tblall_clients.client_id as newclientid,tblclients.company as company');
    $CI->db->from('tblall_clients');
	 $CI->db->join('tblclients', 'tblclients.userid = tblall_clients.client_id');
	if($rel_id!='')
    $CI->db->where('project_id', $rel_id );
    return $CI->db->get()->result_array();
}
function assign_allclients($assignded_ids,$rel_id)
{
    
    $CI = &get_instance();
    $all_old_assignees = get_all_extraclients($rel_id);
    $old_assigned = array_column($all_old_assignees, 'newclientid');
    //Delete old assigned client ids
    $CI->db->where('project_id',$rel_id);
    $CI->db->delete('tblall_clients');
    

    foreach ($assignded_ids as $key => $value) {
        $CI->db->insert('tblall_clients', array(
                'project_id' => $rel_id,
                'client_id' => $value,
               // 'dateadded'=>date('Y-m-d H:i:s')
            ));
     
    }
}
function get_casenumber_by_project($id,$project_id){
    $CI = &get_instance();
    if($id){
      $qry =  $CI->db->get_where('tblcase_details',array('instance_id'=>$id,'project_id'=>$project_id));
      if($qry->num_rows() > 0)
        return $qry->row()->case_number;
      else
        return ''; 
    }
}
function fetch_courtinstance_numrows($pid)
    {
           $CI =& get_instance();
            $CI->db->select('*');

            $CI->db->from(db_prefix() . 'case_details');

            $CI->db->where('project_id',$pid);
             
           return $CI->db->get()->num_rows();
        
    }

?>