<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customer_kyc_uploaded_file_to_staff extends App_mail_template
{
    protected $for = 'staff';

    protected $staff_email;

    protected $staffid;

    public $slug = 'new-customer-kyc-file-uploaded-to-staff';

    public $rel_type = 'staff';

    public function __construct($statement,$customer_id,$staff_email,$staffid,$attach_pdf, $cc = '')
    {
        parent::__construct();
		$this->statement=$statement;
		$this->customer_id=$customer_id;
        $this->staff_email = $staff_email;
        $this->staffid    = $staffid;
		$this->attach_pdf = $attach_pdf;
        $this->cc         = $cc;
    }

    public function build()
    { print_r($this->staff_email);
		if ($this->attach_pdf) {
			
            $pdf = customerkyc_summary_pdf($this->statement);
            $pdf_file_name = slug_it(_l('clientkyc_summary') . '-' . $this->statement->company);

            $attach = $pdf->Output($pdf_file_name . '.pdf', 'S');
            
            $this->add_attachment([
                'attachment' => $attach,
                'filename'   => $pdf_file_name . '.pdf',
                'type'       => 'application/pdf',
            ]);
        }
		
		if ($this->ci->input->post('email_attachments')) {
            $_other_attachments = $this->ci->input->post('email_attachments');
            foreach ($_other_attachments as $attachment) {
                $_attachment = $this->ci->clients_model->get_kycfiles($this->customer_id, $attachment);
				print_r($attachment);
                $this->add_attachment([
                    'attachment' => get_upload_path_by_type('customer') . $this->customer_id . '/' . $_attachment->file_name,
                    'filename'   => $_attachment->file_name,
                    'type'       => $_attachment->file_type,
                    'read'       => true,
                ]);
            }
        }
		
		 $this->to($this->staff_email)
        ->set_rel_id($this->staffid)
		->set_merge_fields('staff_merge_fields', $this->staffid)
        ->set_merge_fields('client_merge_fields', $this->customer_id);
       
    }
}
