<?php



defined('BASEPATH') or exit('No direct script access allowed');



class Casediary_model extends App_Model

{

	public function __construct()

    {

        parent::__construct();

        $this->load->model('court_model');

        $this->load->model('court_type_model');

        $this->load->model('oppositeparty_model');

        $this->load->model('partytype_model');

        $this->load->model('hallnumber_model');

        $this->load->model('document_types_model');

        $this->load->model('case_nature_model');
		$this->load->model('case_arbitration_model');

        $this->load->model('court_instance_model');

    }

     public function save_dashboard_conflict_search($data){
        $data['dateadded']     = date('Y-m-d H:i:s');
        $data['addedfrom']     = get_staff_user_id();
        $this->db->insert('tblconflicts_search_history', $data);
        $inserted_id = $this->db->insert_id();
        if ($inserted_id) { 
            log_activity('Conflict Search Done [' . $data['search_term'] . ']');
            return $inserted_id;
        }
        return false;
    }

    public function get_communication_center($case_id)

    {

        $this->db->order_by('date','DESC');

        $this->db->where('case_id', $case_id);



        $results = $this->db->get('tblcase_communication_center')->result_array();

        $i=0;

        foreach ($results as $result) { 

            $results[$i]['attachments'] = $this->get_communication_files($result['id']);

            $i++;

        }

        return $results;

    }



     public function get_communication_center_by_id($id)

    {

        $this->db->where('id', $id);

        $result = $this->db->get('tblcase_communication_center')->row();

        $result->attachments = $this->get_communication_files($id);

        return $result;

    }

    



    public function get_communication_files($communication_id)

    {

        $this->db->where('communication_id', $communication_id);

        $s = $this->db->get('tblproject_files')->result_array();

        return $s;

    }



    public function delete_communication($id)

    {

        $this->db->where('id', $id);

        $this->db->delete('tblcase_communication_center');

        //if ($this->db->affected_rows() > 0) {

            return true;

        //}



        //return false;

    }





    

    public function remove_payment_schedule($id)

    {

        if (is_reference_in_table('payment_schedule_id', 'tblinvoices', $id)) {

            return array(

                'referenced' => true,

            );

        }

        $this->db->where('id', $id);

        $this->db->delete('tblpayment_schedules');

        if ($this->db->affected_rows() > 0) {

            //log_activity('Payment Schedule Deleted [' . $id . ']');

            return true;

        }



        return false;

    }

    

    public function get_payment_schedules($id='',$project_id='', $where = array())

    {

        $this->db->select('tblpayment_schedules.*,CONCAT(p_description,"-",p_amount) as schedule');

        $this->db->where($where);

        if(is_numeric($project_id)){

            $this->db->where('tblpayment_schedules.project_id',$project_id);

        }

        if(is_numeric($id)){

            $this->db->where('tblpayment_schedules.id',$id);

            $instance= $this->db->get('tblpayment_schedules')->row();

            return $instance;

        }

        $instances= $this->db->get('tblpayment_schedules')->result_array();        

        return $instances;



    }

    public function add_payment_schedule($data){

        $data['dateadded']     = date('Y-m-d H:i:s');

        $data['addedby']     = get_staff_user_id();

        $this->db->insert('tblpayment_schedules', $data);

        $inserted_id = $this->db->insert_id();

        if ($inserted_id) { 

            //log_activity('Payment Schedule Deleted [' . $id . ']');

            return $inserted_id;

        }

        return false;

    }



     public function update_payment_schedule($data,$id){

        $affectedRows = 0;

        $this->db->where('id', $id);

        $this->db->update('tblpayment_schedules', $data);

        if ($this->db->affected_rows() > 0) { 

            return true;

        }

        return false;

    }





    public function get_clients_of_oppositeparty($id = '')

    {

        $this->db->select('tbloppositeparty.id as id,tbloppositeparty.name as name');

        $this->db->join('tblclient_oppositeparty_rel', 'tbloppositeparty.id=tblclient_oppositeparty_rel.opposite_party_id', 'left');

        if(is_numeric($id)){

            $this->db->where('tblclient_oppositeparty_rel.client_id',$id);   

        }



        $leads = $this->db->get('tbloppositeparty')->result_array();



        return $leads;



    }

    public function add_new_court_instance($data)

    {

        return $this->court_instance_model->add($data);

    }
     public function update_court_instance($data, $id)

    {

        return $this->court_instance_model->update($data, $id);

    }

      public function update_party_type($data, $id)

    {

        return $this->partytype_model->update($data, $id);

    }
    


     public function add_case_details_data($data){

        $data['dateadded']   = date('Y-m-d H:i:s');

        $data['addedfrom']     = get_staff_user_id();

        $data['details_type']  = get_court_instance_name_by_id($data['instance_id']);

        //$assignded_ids = $data['lawyer_id'];

        //$data['lawyer_id'] = json_encode($data['lawyer_id']);

        $this->db->insert('tblcase_details', $data);

        $inserted_id = $this->db->insert_id();

        if ($inserted_id) { 

            //assign_all($assignded_ids,$data['details_type'],$inserted_id,$id);

            return true;

        }

        return false;

    }



    public function update_case_details_data($data,$id){

        $affectedRows = 0;

        //$assignded_ids = $data['lawyer_id'];

        //$data['lawyer_id'] = json_encode($data['lawyer_id']);

        $this->db->where('id', $id);

        $this->db->update('tblcase_details', $data);

        if ($this->db->affected_rows() > 0) { 

            //assign_all($assignded_ids,$data['details_type'],$table_id,$id);

            return true;

        }

        return false;

    }



    

     public function get_project_instances_by_id($id='', $where = array())

    {

        $this->db->select('tblcase_details.*,tblproject_instances.instance_name as instance_name,tblproject_instances.instance_slug as instance_slug,tblcase_details.id as id,tblcourts.name as courtname,tblcase_natures.name as case_nature_name');

        $this->db->join('tblprojects', 'tblprojects.id=tblcase_details.project_id', 'left');

        $this->db->join('tblproject_instances', 'tblproject_instances.id=tblcase_details.instance_id', 'left');

        $this->db->join('tblcourts', 'tblcase_details.court_id=tblcourts.id', 'left');

        $this->db->join('tblcase_natures', 'tblcase_natures.id=tblcase_details.instance_casenature', 'left');

       

        $this->db->where($where);

        if(is_numeric($id)){

            $this->db->where('tblcase_details.id',$id);

            $instance= $this->db->get('tblcase_details')->row();

            return $instance;





        }

        $instances= $this->db->get('tblcase_details')->result_array();

        $i         = 0;

        

        return $instances;



    }

    



    public function get_project_instances_by_project_id($project_id='', $where = array())

    {

        $this->db->select('tblcase_details.*,tblproject_instances.instance_name as instance_name,tblproject_instances.instance_slug as instance_slug,tblcase_details.id as id,tblcase_details.id as id,tblcourts.name as courtname,tblcase_natures.name as case_nature_name');

        $this->db->join('tblprojects', 'tblprojects.id=tblcase_details.project_id', 'left');

        $this->db->join('tblproject_instances', 'tblproject_instances.id=tblcase_details.instance_id', 'left');

        $this->db->join('tblcourts', 'tblcase_details.court_id=tblcourts.id', 'left');

        $this->db->join('tblcase_natures', 'tblcase_natures.id=tblcase_details.instance_casenature', 'left');



        $this->db->where($where);

        if(is_numeric($project_id)){

            $this->db->where('project_id',$project_id);



        }

        $instances = $this->db->get('tblcase_details')->result_array();

        $i         = 0;

        

        /*foreach ($instances as $instance) {

            $instances[$i]['lawyers_assigned'] = get_all_assignees($instance['details_type'],$instance['id']);

            $i++;

        }*/



        return $instances;



    }

    



     public function delete_case_update($note_id)

    {

        $this->db->where('id', $note_id);

        $note = $this->db->get('tblproject_updates')->row();

        if ($note->addedfrom != get_staff_user_id() && !is_admin()) {

            return false;

        }

        $this->db->where('id', $note_id);

        $this->db->delete('tblproject_updates');

        if ($this->db->affected_rows() > 0) {

            return true;

        }



        return false;

    }

    public function edit_case_update($data, $id)

    {

        $this->db->where('id', $id);

        $this->db->update('tblproject_updates', array(

            'content' => nl2br($data['content'])

        ));

        if ($this->db->affected_rows() > 0) {  

            return true;

        }

        return false;

    }

    public function save_case_update($data, $project_id)

    {

        

        $this->db->insert(db_prefix() . 'project_updates', [

            'addedfrom'   => get_staff_user_id(),

            'content'    => $data['content'],

            'rel_id' => $project_id,

            'dateadded' => date('Y-m-d H:i:s'),

            'rel_type' => $data['rel_type']

        ]);

        $insert_id = $this->db->insert_id();

        if ($insert_id) {

            return true;

        }



        return false;

    }



    public function get_case_updates($case_id,$rel_type)

    {

        $this->db->where('rel_id', $case_id);

        $this->db->where('rel_type', $rel_type);

        return $this->db->get('tblproject_updates')->result_array();

    }





    public function get_document_types($id = '')

    {

        return $this->document_types_model->get($id);

    }



     /**

     * @param  integer ID (optional)

     * @return mixed

     * Get Court object based on passed id if not passed id return array of all types

     */

    public function get_courts($id = '',$type='')

    {

        return $this->court_model->get($id,$type);

    }



    public function get_casenatures($id = '',$type='')

    {

        return $this->case_nature_model->get($id,$type);

    }
	public function get_casearbitration($id = '')

    {

        return $this->case_arbitration_model->get($id);

    }

    /**

     * @param  integer ID (optional)

     * @return mixed

     * Get Court Type object based on passed id if not passed id return array of all types

     */

    public function get_court_types($id = '')

    {

        return $this->court_type_model->get($id);

    }

    public function get_oppositeparty($id = '')

    {

        return $this->oppositeparty_model->get($id);

    }

    public function get_partytypes($id = '')
    {
        return $this->partytype_model->get($id);
    }

    public function delete_partytype($id='')
    {
        return $this->partytype_model->delete($id);
    }


    public function delete_court($id='')

    {

        return $this->court_model->delete($id);

    }

     public function delete_court_instance($id='')

    {

        return $this->court_instance_model->delete($id);

    }




    public function delete_case_nature($id='')

    {

        return $this->case_nature_model->delete($id);

    }

	public function delete_case_arbitration($id='')

    {

        return $this->case_arbitration_model->delete($id);

    }

     public function delete_hearing_reference($id='')

    {

        return $this->hearing_reference_model->delete($id);

    }



    public function delete_court_region($id='')

    {

        return $this->court_region_model->delete($id);

    }



    public function delete_hall_number($id='')

    {

        return $this->hallnumber_model->delete($id);

    }



    public function delete_document_type($id='')

    {

        return $this->document_types_model->delete($id);

    }



    





    public function update_court($data, $id)

    {

        return $this->court_model->update($data, $id);

    }



     public function update_case_nature($data, $id)

    {

        return $this->case_nature_model->update($data, $id);

    }
   public function update_case_arbitration($data, $id)

    {

        return $this->case_arbitration_model->update($data, $id);

    }


    public function add_new_court($data)

    {

        return $this->court_model->add($data);

    }



     public function add_case_nature($data)

    {

        return $this->case_nature_model->add($data);

    }
	
	  public function add_case_arbitration($data)

    {

        return $this->case_arbitration_model->add($data);

    }



    public function add_document_type($data)

    {

        return $this->document_types_model->add($data);

    }



    

    



     /**

     * Add new contract type

     * @param mixed $data All $_POST data

     */

    public function add_new_hearing_reference($data)

    {

        return $this->hearing_reference_model->add($data);

    }



     /**

     * Add new contract type

     * @param mixed $data All $_POST data

     */

    public function add_new_CourtType($data)

    {

        return $this->court_type_model->add($data);

    }



     public function add_new_hallnumber($data)

    {

        return $this->hallnumber_model->add($data);

    }



     /**

     * Add new contract type

     * @param mixed $data All $_POST data

     */

    public function add_new_court_regions($data)

    {

        return $this->court_region_model->add($data);

    }



     public function add_new_oppositeparty($data)

    {

        return $this->oppositeparty_model->add($data);

    }



    public function add_new_partytype($data)

    {

        return $this->partytype_model->add($data);

    }

    



     /**

     * Add new Area Descriptions

     * @param mixed $data All $_POST data

     */

    public function add_new_court_degree($data)

    {

        return $this->court_degree_model->add($data);

    }



    public function update_court_type($data, $id)

    {

        return $this->court_type_model->update($data, $id);

    }



     public function update_hearing_reference($data, $id)

    {

        return $this->hearing_reference_model->update($data, $id);

    }



    public function update_court_region($data, $id)

    {

        return $this->court_region_model->update($data, $id);

    }



     public function update_hall_number($data, $id)

    {

        return $this->hallnumber_model->update($data, $id);

    }



     public function update_document_type($data, $id)

    {

        return $this->document_types_model->update($data, $id);

    }



    



    public function get_matter_templates_by_case_type($casetype){



        return $this->db->select('name,id')

                ->from('tblcasetemplates')

                ->where('case_type',$casetype)

                ->get()->result_array();

    }



    public function get_scopes($case_id)

    {

        $this->db->where('case_id', $case_id);

        return $this->db->get('tblcase_scopes')->result_array();

    }



     public function add_scope($data){

        $this->db->insert('tblcase_scopes',$data);

        return true;

    }



    public function edit_scope($data, $id)

    {

        $this->db->where('id', $id);

        $this->db->update('tblcase_scopes', array(

            'scope_description' => nl2br($data['description'])

        ));

        if ($this->db->affected_rows() > 0) {

            return true;

        }



        return false;

    }

   

    public function delete_scope($id)

    {

        $this->db->where('id', $id);

        $this->db->delete('tblcase_scopes');

        //if ($this->db->affected_rows() > 0) {

            return true;

        //}



        //return false;

    }





     public function clients_bd_report($id = '', $where = array())

    {

        $this->db->select('*,tblleads.name, tblleads.id,tblleads_status.name as status_name,tblleads_sources.name as source_name');

        $this->db->join('tblleads_status', 'tblleads_status.id=tblleads.status', 'left');

        $this->db->join('tblleads_sources', 'tblleads_sources.id=tblleads.source', 'left');

        if ($this->input->post('view_status')) {

            //array_push($where, 'AND status IN ('.implode(',',$this->input->post('view_status')).')');

            $statuses = implode(',',$this->input->post('view_status'));

            $this->db->where_in('status',$this->input->post('view_status'));

        }



       





        $this->db->where($where);



        if ($this->input->post()) {

            $from_date = to_sql_date($this->input->post('staff_report_from_date'));

            $to_date   = to_sql_date($this->input->post('staff_report_to_date'));

            if ($this->input->post('client')) {

                $this->db->where('client_id ',$this->input->post('client'));

            }

        }

        if (isset($to_date) && isset($from_date)) {

            $this->db->where('dateadded >=',$from_date);

            $this->db->where('dateadded <=',$to_date);

        }



        /*if ($this->input->post('view_assigned')) {

            $assignees = $this->input->post('view_assigned');

           $this->db->where(' tblleads.id IN (SELECT lead_id FROM tblleadassignees WHERE staffid = '.$assignees .')');

        }*/

        

        $leads = $this->db->get('tblleads')->result_array();

        $i     = 0;

        /*foreach ($leads as $lead) {

            $leads[$i]['assignees'] = $this->get_lead_assignees($lead['id']);

            $i++;

        }*/



        return $leads;



    }



    public function get_all_tasks(){

        $this->db->select('id,name');

        return $this->db->get('tbltasks')->result_array();

    }





    public function perform_search($q,$data=array())

    {

        $q = trim($q);

        $this->load->model('staff_model');

        $is_admin                       = is_admin();

        $result                         = [];

        $limit                          = get_option('limit_top_search_bar_results_to');

        $have_assigned_customers        = have_assigned_customers();

        $have_permission_customers_view = has_permission('customers', '', 'view');

        

        $wide_search = isset($data['wide_search']) ? $data['wide_search'] : '';



        if(isset($data['chk_clients'])){

        if ($have_assigned_customers || $have_permission_customers_view) {



            // Clients

            $this->db->select(implode(',', prefixed_table_fields_array(db_prefix() . 'clients')) . ',' . get_sql_select_client_company());



            $this->db->join(db_prefix() . 'countries', db_prefix() . 'countries.country_id = ' . db_prefix() . 'clients.country', 'left');

            $this->db->join(db_prefix() . 'contacts', db_prefix() . 'contacts.userid = ' . db_prefix() . 'clients.userid AND is_primary = 1', 'left');

            $this->db->from(db_prefix() . 'clients');

            if ($have_assigned_customers && !$have_permission_customers_view) {

                $this->db->where(db_prefix() . 'clients.userid IN (SELECT customer_id FROM ' . db_prefix() . 'customer_admins WHERE staff_id=' . get_staff_user_id() . ')');

            }



             if($wide_search != ''){

                 $this->db->where('(company LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR ' . db_prefix() . 'clients.phonenumber LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR city LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR zip LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR state LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR address LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR ' . db_prefix() . 'countries.short_name LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR ' . db_prefix() . 'countries.long_name LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR ' . db_prefix() . 'countries.numcode LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                )');

                



             }

             else{

               $this->db->where('company',$q);

                $this->db->or_where('clients.phonenumber',$q);

                $this->db->or_where('city',$q);

                $this->db->or_where('zip',$q);

                $this->db->or_where('state',$q);

                $this->db->or_where('address',$q);

             }

            



            $this->db->limit($limit);

            $result[] = [

                'result'         => $this->db->get()->result_array(),

                'type'           => 'clients',

                'search_heading' => _l('clients'),

            ];

          }

        }





        $where_contacts = '';

        if ($have_assigned_customers && !$have_permission_customers_view) {

            $where_contacts = db_prefix() . 'contacts.userid IN (SELECT customer_id FROM ' . db_prefix() . 'customer_admins WHERE staff_id=' . get_staff_user_id() . ')';

        }



        if(isset($data['chk_contacts'])){

            $contacts_search = $this->_search_contacts($q, $limit, $where_contacts,$wide_search);

            if (count($contacts_search['result']) > 0) {

                $result[] = $contacts_search;

            }

        }



        if(isset($data['chk_leads'])){

            $leads_search = $this->_search_leads($q, $limit);

            if (count($leads_search['result']) > 0) {

                $result[] = $leads_search;

            }

        }



        if(isset($data['chk_projects'])){



            $projects_search = $this->_search_projects($q, $limit);

            if (count($projects_search['result']) > 0) {

                $result[] = $projects_search;

            }

        }



        if(isset($data['chk_oppositeparty'])){

           

            $oppos_search = $this->_search_opposite_party($q, $limit,'',$wide_search);

            if (count($oppos_search['result']) > 0) {

                $result[] = $oppos_search;

            }

        }





        $result = hooks()->apply_filters('global_search_result_query', $result, $q, $limit);



        return $result;

    }



     public function _search_projects($q, $limit = 0, $where = false,$order_by='name',$asc='ASC')

    {

        $result = [

            'result'         => [],

            'type'           => 'projects',

            'search_heading' => _l('projects'),

        ];



        $projects = has_permission('projects', '', 'view');

        // Projects

        $this->db->select();

        $this->db->from(db_prefix() . 'projects');

        $this->db->join(db_prefix() . 'clients', db_prefix() . 'clients.userid = ' . db_prefix() . 'projects.clientid');

        if (!$projects) {

            $this->db->where(db_prefix() . 'projects.id IN (SELECT project_id FROM ' . db_prefix() . 'project_members WHERE staff_id=' . get_staff_user_id() . ')');

        }

        if ($where != false) {

            $this->db->where($where);

        }

        if (!startsWith($q, '#')) {

            $this->db->where('(

                description LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR name LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                )');

        } else {

            $this->db->where('id IN

                (SELECT rel_id FROM ' . db_prefix() . 'taggables WHERE tag_id IN

                (SELECT id FROM ' . db_prefix() . 'tags WHERE name="' . $this->db->escape_str(strafter($q, '#')) . '")

                AND ' . db_prefix() . 'taggables.rel_type=\'project\' GROUP BY rel_id HAVING COUNT(tag_id) = 1)

                ');

        }



        if ($limit != 0) {

            $this->db->limit($limit);

        }



        $this->db->order_by($order_by, $asc);

        $result['result'] = $this->db->get()->result_array();



        return $result;

    }



    public function _search_leads($q, $limit = 0, $where = [])

    {

        $result = [

            'result'         => [],

            'type'           => 'leads',

            'search_heading' => _l('leads'),

        ];



        $has_permission_view = has_permission('leads', '', 'view');



        if (is_staff_member()) {

            // Leads

            $this->db->select();

            $this->db->from(db_prefix() . 'leads');



            if (!$has_permission_view) {

                $this->db->where('(assigned = ' . get_staff_user_id() . ' OR addedfrom = ' . get_staff_user_id() . ' OR is_public=1)');

            }



            if (!startsWith($q, '#')) {

                $this->db->where('(name LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                    OR title LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                    OR company LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                    OR zip LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                    OR city LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                    OR state LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                    OR address LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                    OR email LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                    OR phonenumber LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                    )');

            } else {

                $this->db->where('id IN

                    (SELECT rel_id FROM ' . db_prefix() . 'taggables WHERE tag_id IN

                    (SELECT id FROM ' . db_prefix() . 'tags WHERE name="' . $this->db->escape_str(strafter($q, '#')) . '")

                    AND ' . db_prefix() . 'taggables.rel_type=\'lead\' GROUP BY rel_id HAVING COUNT(tag_id) = 1)

                    ');

            }





            $this->db->where($where);



            if ($limit != 0) {

                $this->db->limit($limit);

            }

            $this->db->order_by('name', 'ASC');

            $result['result'] = $this->db->get()->result_array();

        }



        return $result;

    }



    public function _search_contacts($q, $limit = 0, $where = '',$wide_search='')

    {

        $result = [

            'result'         => [],

            'type'           => 'contacts',

            'search_heading' => _l('customer_contacts'),

        ];



        $have_assigned_customers        = have_assigned_customers();

        $have_permission_customers_view = has_permission('customers', '', 'view');



        if ($have_assigned_customers || $have_permission_customers_view) {

            // Contacts

            $this->db->select(implode(',', prefixed_table_fields_array(db_prefix() . 'contacts')) . ',company');

            $this->db->from(db_prefix() . 'contacts');



            $this->db->join(db_prefix() . 'clients', '' . db_prefix() . 'clients.userid=' . db_prefix() . 'contacts.userid', 'left');

            if($wide_search != ''){

                $this->db->where('(firstname LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR lastname LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR email LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR CONCAT(firstname, \' \', lastname) LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR CONCAT(lastname, \' \', firstname) LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR ' . db_prefix() . 'contacts.phonenumber LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR ' . db_prefix() . 'contacts.title LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR company LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                )');

               



             }

             else{

                $this->db->where('firstname',$q);

                $this->db->or_where('lastname',$q);

                $this->db->or_where('email',$q);

                //$this->db->or_where('CONCAT(firstname, \' \', lastname)',$q);

                $this->db->or_where('contacts.phonenumber',$q);

                $this->db->or_where('contacts.title',$q);

            }



            if ($where != '') {

                $this->db->where($where);

            }



            if ($limit != 0) {

                $this->db->limit($limit);

            }



            $this->db->order_by('firstname', 'ASC');

            $result['result'] = $this->db->get()->result_array();

        }



        return $result;

    }



     public function _search_opposite_party($q, $limit = 0, $where = '',$wide_search='')

    {

        $result = [

            'result'         => [],

            'type'           => 'oppositeparty',

            'search_heading' => _l('casediary_oppositeparty'),

        ];



        //$have_assigned_customers        = have_assigned_customers();

        //$have_permission_customers_view = has_permission('customers', '', 'view');



        //if ($have_assigned_customers || $have_permission_customers_view) {

            // Contacts

            $this->db->select('*');

            $this->db->from(db_prefix() . 'oppositeparty');

            if($wide_search != ''){



                $this->db->where('(name LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR firstname LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR lastname LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                OR email LIKE "%' . $this->db->escape_like_str($q) . '%" ESCAPE \'!\'

                )');

               



             }

             else{



                $this->db->where('name',$q);

                $this->db->or_where('firstname',$q);

                $this->db->or_where('lastname',$q);

                //$this->db->or_where('CONCAT(firstname, \' \', lastname)',$q);

                $this->db->or_where('email',$q);

            }

            if ($where != '') {

                $this->db->where($where);

            }



            if ($limit != 0) {

                $this->db->limit($limit);

            }



            $this->db->order_by('name', 'ASC');

            $result['result'] = $this->db->get()->result_array();

        //}



        return $result;

    }



    



    public function get_details($id = '',$project_id='',$type='', $where = array())

    {

        $this->db->select('tblcase_details.*');

        $this->db->join('tblprojects', 'tblprojects.id=tblcase_details.project_id', 'left');

       

        $this->db->where($where);

        if(is_numeric($project_id)){

            $this->db->where('project_id',$project_id);   

        }



        if($type != '' ){

            $this->db->where('instance_id',$type);   

        }



        if(is_numeric($id)){

            $this->db->where('id',$id);

            return $this->db->get('tblcase_details')->row(); 

        }



        $leads = $this->db->get('tblcase_details')->row();



        return $leads;



    }

    



     public function update_project_table_data($data,$id){

        $affectedRows = 0;

      

        $this->db->where('id', $id);

        $this->db->update('tblprojects', $data);

        if ($this->db->affected_rows() > 0) { 

    

            return true;

        }

        return false;

    }





    public function get_debt_collection_details($id = '',$project_id='' ,$where = array())

    {

        $this->db->select('tbldebt_collection_details.*');

        $this->db->join('tblprojects', 'tblprojects.id=tbldebt_collection_details.project_id', 'inner');

       

        $this->db->where($where);

        if(is_numeric($project_id)){

            $this->db->where('project_id',$project_id);   

        }



        if(is_numeric($id)){

            $this->db->where('id',$id);

            return $this->db->get('tbldebt_collection_details')->row(); 

        }



        $leads = $this->db->get('tbldebt_collection_details')->row();



        return $leads;



    }



    public function update_debt_collection_details($data,$id){

        $affectedRows = 0;

        $table_id = $data['id'];

        unset($data['id']);

        $this->db->where('project_id', $id);

        $this->db->where('id', $table_id);

        $this->db->update('tbldebt_collection_details', $data);

        if ($this->db->affected_rows() > 0) { 

    

            return true;

        }

        return false;

    }



    public function add_debt_collection_details($data,$id){

        $data['datecreated']   = date('Y-m-d H:i:s');

        $data['addedfrom']     = get_staff_user_id();

        $data['project_id']    = $id;

        $insert_id = $this->db->insert('tbldebt_collection_details', $data);

        if ($insert_id) { 

    

            return true;

        }

        return false;

    }

	

     public function verify_status($id,$stable,$status)

    {

        $this->db->where('id', $id);

        $this->db->update($stable, array(

            'active' => $status,

            ));



        if ($this->db->affected_rows() > 0) {

           // logActivity('Installment Verified  [ID: ' . $id . ' : ' . $status . ']');



            return true;

        }



        return false;

    }

    public function get_courtorders($project_id,$status='')
    { 
        if($status!='')
        {
            $this->db->where('active', $status);
        }

        $this->db->where('project_id', $project_id);

        return $this->db->get('tblcourt_orders')->result_array();

    }

     public function get_courtordernames($id='')

    {

      $this->db->where('active', '1');

        if (is_numeric($id)) {

            $this->db->where('id', $id);



            return $this->db->get('tblcourt_ordernames')->row();

        }

        $types = $this->db->get('tblcourt_ordernames')->result_array();

        return $types;

      }



     public function add_courtorder($data){

         $data['order_date']=to_sql_date($data['order_date']);

         $data['end_date']=isset($data['end_date'])?to_sql_date($data['end_date']):'';

        $this->db->insert('tblcourt_orders',$data);

        return true;

    }



    public function edit_courtorder($data, $id)

    {

         $data['order_date']=to_sql_date($data['order_date']);

          $data['end_date']=isset($data['end_date'])?to_sql_date($data['end_date']):'';

        $this->db->where('id', $id);

        $this->db->update('tblcourt_orders',$data);

        if ($this->db->affected_rows() > 0) {

            return true;

        }



        return false;

    }

   

    public function delete_courtorder($id)

    {

        $this->db->where('id', $id);

        $this->db->delete('tblcourt_orders');
        //if ($this->db->affected_rows() > 0) {
            return true;
        //}
        //return false;

    }

    public function get_document_types_bycategory($cid = '')
    {
        return $this->document_types_model->getbycategory($cid);

    }




    

}