<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Public_weblinks_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get article by id
     * @param  string $id   article ID
     * @param  string $slug if search by slug
     * @return mixed       if ID or slug passed return object else array
     */
	
    /**
     * Get all KGB (Knowledge base groups)
     * @param  mixed $id Optional - KB Group
     * @param  mixed $active Optional - actve groups or not
     * @return mixed      array if not id passed else object
     */
    public function get($id = '', $active = '')
    {
        if (is_numeric($active)) {
            $this->db->where('active', $active);
        }
        if (is_numeric($id)) {
            $this->db->where('id', $id);

            return $this->db->get(db_prefix() . 'public_weblinks')->row();
        }
        $this->db->order_by('id', 'desc');

        return $this->db->get(db_prefix() . 'public_weblinks')->result_array();
    }


    /**
     * Add new article
     * @param array $data article data
     */
    public function add_weblink($data)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }
    
        $data['dateadded'] = date('Y-m-d H:i:s');
     
        $data = hooks()->apply_filters('before_add_kb_article', $data);

        $this->db->insert(db_prefix() . 'public_weblinks', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New URL Added [ID: ' . $insert_id . ']');
        }

        return $insert_id;
    }

    /**
     * Update article
     * @param  array $data article data
     * @param  mixed $id   articleid
     * @return boolean
     */
    public function update_weblink($data, $id)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }

       
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'public_weblinks', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Web URL Updated [ID: ' . $id . ']');

            return true;
        }

        return false;
    }



    /**
     * Change article status
     * @param  mixed $id     article id
     * @param  boolean $status is active or not
     */
    public function change_weblink_status($id, $status)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'public_weblinks', [
            'active' => $status,
        ]);
        log_activity('Article Status Changed [ID: ' . $id . ' Status: ' . $status . ']');
    }


    public function delete_weblink($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'public_weblinks');
        if ($this->db->affected_rows() > 0) {
         
            log_activity('Web URL Deleted [ID: ' . $id . ']');

            return true;
        }

        return false;
    }
  
}
