<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Trust_accounting_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @param  integer ID (optional)
     * @param  boolean (optional)
     * @return mixed
     * Get designation object based on passed id if not passed id return array of all designations
     * Second parameter is to check if the request is coming from clientarea, so if any designations are hidden from client to exclude
     */
    public function get($id = false, $clientarea = false)
    {
        
        if (is_numeric($id)) {
            $this->db->where('id', $id);

            return $this->db->get('tbltrust_accounts')->row();
        }

        $designations = $this->db->get('tbltrust_accounts')->result_array();
        return $designations;
    }

    /**
     * @param array $_POST data
     * @return integer
     * Add new department
     */
    public function add_trust_account($data)
    {
        $data['dateadded']  = date('Y-m-d H:i:s');
        $data['addedfrom']  = get_staff_user_id();
        $this->db->insert('tbltrust_accounts', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Trust Account Added [' . $data['trust_account_name'] . ', ID: ' . $insert_id . ']');
        }

        return $insert_id;
    }

    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update department to database
     */
    public function update_trust_account($data, $id)
    {
    
        $this->db->where('id', $id);
        $this->db->update('tbltrust_accounts', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Trust Account Updated [Name: ' . $data['trust_account_name'] . ', ID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * @param  integer ID
     * @return mixed
     * Delete department from database, if used return array with key referenced
     */
    public function delete_trust_account($id)
    {
        $current = $this->get($id);
        if (is_reference_in_table('trustaccount_id', 'tblinvoices', $id)) {
            return array(
                'referenced' => true
            );
        }

        if (is_reference_in_table('trust_accountid', 'tblexpenses', $id)) {
            return array(
                'referenced' => true
            );
        }
        $this->db->where('id', $id);
        $this->db->delete('tbltrust_accounts');
        if ($this->db->affected_rows() > 0) {
            log_activity('Trust Account Deleted [ID: ' . $id . ']');

            return true;
        }

        return false;
    }

    public function update_options($data)
    {

        foreach($data['settings'] as $key => $value){
            $this->db->where('name',$key);
            $this->db->update('tbloptions',array('value'=>$value));
        }
        return true;
    }

      /**
     * @param array $_POST data
     * @return integer
     * Add new department
     */
    public function add_payee($data)
    {
        $data['dateadded']  = date('Y-m-d H:i:s');
        $data['addedfrom']  = get_staff_user_id();
        $this->db->insert('tblpayee', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Payee Added [' . $data['payee_name'] . ', ID: ' . $insert_id . ']');
        }

        return $insert_id;
    }

    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update department to database
     */
    public function update_payee($data, $id)
    {
    
        $this->db->where('id', $id);
        $this->db->update('tblpayee', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Payee Updated [Name: ' . $data['payee_name'] . ', ID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * @param  integer ID
     * @return mixed
     * Delete department from database, if used return array with key referenced
     */
    public function delete_payee($id)
    {
        $current = $this->get($id);
        if (is_reference_in_table('payee_id', 'tblexpenses', $id)) {
            return array(
                'referenced' => true
            );
        }
        $this->db->where('id', $id);
        $this->db->delete('tblpayee');
        if ($this->db->affected_rows() > 0) {
            log_activity('Payee Deleted [ID: ' . $id . ']');

            return true;
        }

        return false;
    }

     public function get_trust_account_summary($trustaccount_id, $from, $to)
    {
        if (!class_exists('Invoices_model', false)) {
            $this->load->model('invoices_model');
        }

        $sql = 'SELECT
        ' . db_prefix() . 'invoices.id as invoice_id,
        hash,
        ' . db_prefix() . 'invoices.date as date,
        ' . db_prefix() . 'invoices.duedate,
        concat(' . db_prefix() . 'invoices.date, \' \', RIGHT(' . db_prefix() . 'invoices.datecreated,LOCATE(\' \',' . db_prefix() . 'invoices.datecreated) - 3)) as tmp_date,
        ' . db_prefix() . 'invoices.duedate as duedate,
        ' . db_prefix() . 'invoices.total as invoice_amount,
        ' . db_prefix() . 'invoices.project_id as project_id,
        ' . db_prefix() . 'invoices.clientid as clientid
        FROM ' . db_prefix() . 'invoices WHERE advance_invoice= "y" ';

        if(is_numeric($trustaccount_id)){
           $sql .= ' AND trustaccount_id =' . $this->db->escape_str($trustaccount_id);
        }
        if ($from == $to) {
            $sqlDate = 'date="' . $this->db->escape_str($from) . '"';
        } else {
            $sqlDate = '(date BETWEEN "' . $this->db->escape_str($from) . '" AND "' . $this->db->escape_str($to) . '")';
        }

        $sql .= ' AND ' . $sqlDate;

        $invoices = $this->db->query($sql . '
            AND status != ' . Invoices_model::STATUS_DRAFT . '
            AND status != ' . Invoices_model::STATUS_CANCELLED . '
            ORDER By date DESC')->result_array();

        // expenses -------------------

        $sqle = 'SELECT
        ' . db_prefix() . 'expenses.id as expense_id,
        ' . db_prefix() . 'expenses.date as date,
        ' . db_prefix() . 'expenses.expense_name as expense_name,
        concat(' . db_prefix() . 'expenses.date, \' \', RIGHT(' . db_prefix() . 'expenses.dateadded,LOCATE(\' \',' . db_prefix() . 'expenses.dateadded) - 3)) as tmp_date,
        ' . db_prefix() . 'expenses.amount as expense_amount,
        ' . db_prefix() . 'expenses.project_id as project_id,
        ' . db_prefix() . 'expenses.clientid as clientid,
        ' . db_prefix() . 'expenses.payee_id as payee_id
        FROM ' . db_prefix() . 'expenses WHERE deduct_from_advance = "y" ';

        if(is_numeric($trustaccount_id)){
           $sqle .= ' AND trust_accountid =' . $this->db->escape_str($trustaccount_id);
        }
        if ($from == $to) {
            $expenseSql  = 'date="' . $this->db->escape_str($from) . '"';
        } else {
            $expenseSql = '(date BETWEEN "' . $this->db->escape_str($from) . '" AND "' . $this->db->escape_str($to) . '")';
        }

        $sqle .= ' AND ' . $expenseSql;

        $expenses = $this->db->query($sqle . ' ORDER By date DESC')->result_array();

        //------------

        // Replace error ambigious column in where clause
        $sqlDatePayments = str_replace('date', db_prefix() . 'invoicepaymentrecords.date', $sqlDate);

        $sql_payments = 'SELECT
        ' . db_prefix() . 'invoicepaymentrecords.id as payment_id,
        ' . db_prefix() . 'invoicepaymentrecords.date as date,
        concat(' . db_prefix() . 'invoicepaymentrecords.date, \' \', RIGHT(' . db_prefix() . 'invoicepaymentrecords.daterecorded,LOCATE(\' \',' . db_prefix() . 'invoicepaymentrecords.daterecorded) - 3)) as tmp_date,
        ' . db_prefix() . 'invoicepaymentrecords.invoiceid as payment_invoice_id,
        ' . db_prefix() . 'invoicepaymentrecords.amount as payment_total,
        ' . db_prefix() . 'invoices.project_id as project_id,
        ' . db_prefix() . 'invoices.clientid as clientid
        FROM ' . db_prefix() . 'invoicepaymentrecords
        JOIN ' . db_prefix() . 'invoices ON ' . db_prefix() . 'invoices.id = ' . db_prefix() . 'invoicepaymentrecords.invoiceid
        WHERE ' . $sqlDatePayments . ' AND '. db_prefix() .'invoices.advance_invoice = "y" ';
        if(is_numeric($trustaccount_id)){
            $sql_payments .= ' AND ' . db_prefix() . 'invoices.trustaccount_id = ' . $this->db->escape_str($trustaccount_id);
        }
         
        $sql_payments .=' ORDER by ' . db_prefix() . 'invoicepaymentrecords.date DESC';

        $payments = $this->db->query($sql_payments)->result_array();

        $sqlCreditNoteRefunds = str_replace('date', 'refunded_on', $sqlDate);

        // merge results
        $merged = array_merge( $payments,$expenses);

        // sort by date
        usort($merged, function ($a, $b) {
            // fake date select sorting
            return strtotime($a['tmp_date']) - strtotime($b['tmp_date']);
        });

        // Define final result variable
        $result = [];
        // Store in result array key
        $result['result'] = $merged;

        // Invoiced amount during the period
        $result['invoiced_amount'] = 0;/*$this->db->query('SELECT
        SUM(' . db_prefix() . 'invoices.total) as invoiced_amount
        FROM ' . db_prefix() . 'invoices
        WHERE advance_invoice = "y" AND  trustaccount_id = ' . $this->db->escape_str($trustaccount_id) . '
        AND ' . $sqlDate . ' AND status != ' . Invoices_model::STATUS_DRAFT . ' AND status != ' . Invoices_model::STATUS_CANCELLED . '')
            ->row()->invoiced_amount;*/

        if ($result['invoiced_amount'] === null) {
            $result['invoiced_amount'] = 0;
        }

        $result['refunds_amount'] = 0;/*$this->db->query('SELECT
        SUM(' . db_prefix() . 'creditnote_refunds.amount) as refunds_amount
        FROM ' . db_prefix() . 'creditnote_refunds
        WHERE ' . $sqlCreditNoteRefunds . ' AND credit_note_id IN (SELECT id FROM ' . db_prefix() . 'creditnotes WHERE clientid=' . $this->db->escape_str($trustaccount_id) . ')
        ')->row()->refunds_amount;

        if ($result['refunds_amount'] === null) {
            $result['refunds_amount'] = 0;
        }*/

        $result['invoiced_amount'] = $result['invoiced_amount'] ;

        // Amount paid during the period
        $result['amount_paid'] = 0;/*$this->db->query('SELECT
        SUM(' . db_prefix() . 'invoicepaymentrecords.amount) as amount_paid
        FROM ' . db_prefix() . 'invoicepaymentrecords
        JOIN ' . db_prefix() . 'invoices ON ' . db_prefix() . 'invoices.id = ' . db_prefix() . 'invoicepaymentrecords.invoiceid
        WHERE ' . $sqlDatePayments . ' AND ' . db_prefix() . 'invoices.trustaccount_id = ' . $this->db->escape_str($trustaccount_id).' AND '. db_prefix() .'invoices.advance_invoice = "y"')
            ->row()->amount_paid;*/

        if ($result['amount_paid'] === null) {
            $result['amount_paid'] = 0;
        }

        // expense amount during the period
        $result['expensed_amount'] = 0;/*$this->db->query('SELECT
        SUM(' . db_prefix() . 'expenses.amount) as expensed_amount
        FROM ' . db_prefix() . 'expenses
        WHERE deduct_from_advance = "y" AND  trust_accountid = ' . $this->db->escape_str($trustaccount_id) . '
        AND ' . $expenseSql . '')
            ->row()->expensed_amount;*/

        if ($result['expensed_amount'] === null) {
            $result['expensed_amount'] = 0;
        }
        // Beginning balance is all invoices amount before the FROM date - payments received before FROM date
        $result['beginning_balance'] = 0;/*$this->db->query('
            SELECT (
           
            SELECT COALESCE(SUM(' . db_prefix() . 'invoicepaymentrecords.amount),0)
            FROM ' . db_prefix() . 'invoicepaymentrecords
            JOIN ' . db_prefix() . 'invoices ON ' . db_prefix() . 'invoices.id = ' . db_prefix() . 'invoicepaymentrecords.invoiceid
            WHERE ' . db_prefix() . 'invoicepaymentrecords.date < "' . $this->db->escape_str($from) . '"
            AND ' . db_prefix() . 'invoices.trustaccount_id=' . $this->db->escape_str($trustaccount_id) . '
            ) - (
                SELECT COALESCE(SUM(' . db_prefix() . 'expenses.amount),0)
                FROM ' . db_prefix() . 'expenses
                WHERE deduct_from_advance = "y" AND  ' . db_prefix() . 'expenses.date < "' . $this->db->escape_str($from) . '"
                AND ' . db_prefix() . 'expenses.trust_accountid=' . $this->db->escape_str($trustaccount_id) . '
            
        
            )as beginning_balance FROM ' . db_prefix() . 'invoices
            WHERE advance_invoice = "y" 
            AND date < "' . $this->db->escape_str($from) . '"
            AND trustaccount_id = ' . $this->db->escape_str($trustaccount_id) . '
            AND status = "2"
            AND status != ' . Invoices_model::STATUS_DRAFT . '
            AND status != ' . Invoices_model::STATUS_CANCELLED)
              ->row()->beginning_balance;*/

        if ($result['beginning_balance'] === null) {
            $result['beginning_balance'] = 0;
        }

        $dec = get_decimal_places();

        if (function_exists('bcsub')) {
            $result['balance_due'] = bcsub($result['amount_paid'], $result['expensed_amount'], $dec);
            $result['balance_due'] = bcadd($result['balance_due'], $result['beginning_balance'], $dec);
            $result['balance_due'] = bcadd($result['balance_due'], $result['refunds_amount'], $dec);
        } else {
            $result['balance_due'] = number_format($result['amount_paid'] - $result['expensed_amount'], $dec, '.', '');
            $result['balance_due'] = $result['balance_due'] + number_format($result['beginning_balance'], $dec, '.', '');
            $result['balance_due'] = $result['balance_due'] + number_format($result['refunds_amount'], $dec, '.', '');
        }

        // Subtract amount paid - refund, because the refund is not actually paid amount
        $result['amount_paid'] = $result['amount_paid'] - $result['refunds_amount'];

        $result['client_id'] = $trustaccount_id;
        $result['client']    = [];//$this->clients_model->get($customer_id);
        $result['from']      = $from;
        $result['to']        = $to;
        $this->load->model('currencies_model');

        /*$customer_currency = $this->clients_model->get_customer_default_currency($customer_id);
        $this->load->model('currencies_model');

        if ($customer_currency != 0) {
            $currency = $this->currencies_model->get($customer_currency);
        } else {*/
            $currency = $this->currencies_model->get_base_currency();
        //}

        $result['currency'] = $currency;

        return $result;
    }




}
