<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<script>
    var weekly_payments_statistics;
    var user_dashboard_visibility = <?php echo $user_dashboard_visibility; ?>;
    $(function() {
        $( "[data-container]" ).sortable({
            connectWith: "[data-container]",
            helper:'clone',
            handle:'.widget-dragger',
            tolerance:'pointer',
            forcePlaceholderSize: true,
            placeholder: 'placeholder-dashboard-widgets',
            start:function(event,ui) {
                $("body,#wrapper").addClass('noscroll');
                $('body').find('[data-container]').css('min-height','20px');
            },
            stop:function(event,ui) {
                $("body,#wrapper").removeClass('noscroll');
                $('body').find('[data-container]').removeAttr('style');
            },
            update: function(event, ui) {
                if (this === ui.item.parent()[0]) {
                    var data = {};
                    $.each($("[data-container]"),function(){
                        var cId = $(this).attr('data-container');
                        data[cId] = $(this).sortable('toArray');
                        if(data[cId].length == 0) {
                            data[cId] = 'empty';
                        }
                    });
                    $.post(admin_url+'staff/save_dashboard_widgets_order', data, "json");
                }
            }
        });

        // Read more for dashboard todo items
        $('.read-more').readmore({
            collapsedHeight:150,
            moreLink: "<a href=\"#\"><?php echo _l('read_more'); ?></a>",
            lessLink: "<a href=\"#\"><?php echo _l('show_less'); ?></a>",
        });

        $('body').on('click','#viewWidgetableArea',function(e){
            e.preventDefault();

            if(!$(this).hasClass('preview')) {
                $(this).html("<?php echo _l('hide_widgetable_area'); ?>");
                $('[data-container]').append('<div class="placeholder-dashboard-widgets pl-preview"></div>');
            } else {
                $(this).html("<?php echo _l('view_widgetable_area'); ?>");
                $('[data-container]').find('.pl-preview').remove();
            }

            $('[data-container]').toggleClass('preview-widgets');
            $(this).toggleClass('preview');
        });

        var $widgets = $('.widget');
        var widgetsOptionsHTML = '';
        widgetsOptionsHTML += '<div id="dashboard-options">';
        widgetsOptionsHTML += "<h4><i class='fa fa-question-circle' data-toggle='tooltip' data-placement=\"bottom\" data-title=\"<?php echo _l('widgets_visibility_help_text'); ?>\"></i> <?php echo _l('widgets'); ?></h4><a href=\"<?php echo admin_url('staff/reset_dashboard'); ?>\"><?php echo _l('reset_dashboard'); ?></a>";

        widgetsOptionsHTML += ' | <a href=\"#\" id="viewWidgetableArea"><?php echo _l('view_widgetable_area'); ?></a>';
        widgetsOptionsHTML += '<hr class=\"hr-10\">';

        $.each($widgets,function(){
            var widget = $(this);
            var widgetOptionsHTML = '';
            if(widget.data('name') && widget.html().trim().length > 0) {
                widgetOptionsHTML += '<div class="checkbox checkbox-inline">';
                var wID = widget.attr('id');
                wID = wID.split('widget-');
                wID = wID[wID.length-1];
                var checked= ' ';
                var db_result = $.grep(user_dashboard_visibility, function(e){ return e.id == wID; });
                if(db_result.length >= 0) {
                    // no options saved or really visible
                    if(typeof(db_result[0]) == 'undefined' || db_result[0]['visible'] == 1) {
                        checked = ' checked ';
                    }
                }
                widgetOptionsHTML += '<input type="checkbox" class="widget-visibility" value="'+wID+'"'+checked+'id="widget_option_'+wID+'" name="dashboard_widgets['+wID+']">';
                widgetOptionsHTML += '<label for="widget_option_'+wID+'">'+widget.data('name')+'</label>';
                widgetOptionsHTML += '</div>';
            }
            widgetsOptionsHTML += widgetOptionsHTML;
        });

        $('.screen-options-area').append(widgetsOptionsHTML);
        $('body').find('#dashboard-options input.widget-visibility').on('change',function(){
          if($(this).prop('checked') == false) {
            $('#widget-'+$(this).val()).addClass('hide');
        } else {
            $('#widget-'+$(this).val()).removeClass('hide');
        }

        var data = {};
        var options = $('#dashboard-options input[type="checkbox"]').map(function() {
            return { id: this.value, visible: this.checked ? 1 : 0 };
        }).get();

        data.widgets = options;
/*
        if (typeof(csrfData) !== 'undefined') {
            data[csrfData['token_name']] = csrfData['hash'];
        }
*/
        $.post(admin_url+'staff/save_dashboard_widgets_visibility',data).fail(function(data) {
            // Demo usage, prevent multiple alerts
            if($('body').find('.float-alert').length == 0) {
                alert_float('danger', data.responseText);
            }
        });
    });

        var tickets_chart_departments = $('#tickets-awaiting-reply-by-department');
        var tickets_chart_status = $('#tickets-awaiting-reply-by-status');
        var leads_chart = $('#leads_status_stats');
        var projects_chart = $('#projects_status_stats');

        if (tickets_chart_departments.length > 0) {
            // Tickets awaiting reply by department chart
            var tickets_dep_chart = new Chart(tickets_chart_departments, {
                type: 'doughnut',
                data: <?php echo $tickets_awaiting_reply_by_department; ?>,
            });
        }
        if (tickets_chart_status.length > 0) {
            // Tickets awaiting reply by department chart
            new Chart(tickets_chart_status, {
                type: 'doughnut',
                data: <?php echo $tickets_reply_by_status; ?>,
                options: {
                   onClick:function(evt){
                    onChartClickRedirect(evt,this);
                }
            },
        });
        }
        if (leads_chart.length > 0) {
            // Leads overview status
            new Chart(leads_chart, {
                type: 'doughnut',
                data: <?php echo $leads_status_stats; ?>,
                options:{
                    maintainAspectRatio:false,
                    onClick:function(evt){
                        onChartClickRedirect(evt,this);
                    }
                }
            });
        }
        if(projects_chart.length > 0){
            // Projects statuses
            new Chart(projects_chart, {
                type: 'doughnut',
                data: <?php echo $projects_status_stats; ?>,
                options: {
                    maintainAspectRatio:false,
                    onClick:function(evt){
                       onChartClickRedirect(evt,this);
                   }
               }
           });
        }

        if($(window).width() < 500) {
            // Fix for small devices weekly payment statistics
            $('#weekly-payment-statistics').attr('height', '250');
        }

        fix_user_data_widget_tabs();
        $(window).on('resize', function(){
            $('.horizontal-scrollable-tabs ul.nav-tabs-horizontal').removeAttr('style');
            fix_user_data_widget_tabs();
        });
        // Payments statistics
        init_weekly_payment_statistics( <?php echo $weekly_payment_stats; ?> );
        $('select[name="currency"]').on('change', function() {
            init_weekly_payment_statistics();
        });
    });
    function fix_user_data_widget_tabs(){
        if((app.browser != 'firefox'
                && isRTL == 'false' && is_mobile()) || (app.browser == 'firefox'
                && isRTL == 'false' && is_mobile())){
                $('.horizontal-scrollable-tabs ul.nav-tabs-horizontal').css('margin-bottom','26px');
        }
    }
    function init_weekly_payment_statistics(data) {
        if ($('#weekly-payment-statistics').length > 0) {

            if (typeof(weekly_payments_statistics) !== 'undefined') {
                weekly_payments_statistics.destroy();
            }
            if (typeof(data) == 'undefined') {
                var currency = $('select[name="currency"]').val();
                $.get(admin_url + 'home/weekly_payments_statistics/' + currency, function(response) {
                    weekly_payments_statistics = new Chart($('#weekly-payment-statistics'), {
                        type: 'bar',
                        data: response,
                        options: {
                            responsive:true,
                            scales: {
                                yAxes: [{
                                  ticks: {
                                    beginAtZero: true,
                                }
                            }]
                        },
                    },
                });
                }, 'json');
            } else {
                weekly_payments_statistics = new Chart($('#weekly-payment-statistics'), {
                    type: 'bar',
                    data: data,
                    options: {
                        responsive: true,
                        scales: {
                            yAxes: [{
                              ticks: {
                                beginAtZero: true,
                            }
                        }]
                    },
                },
            });
            }

        }
    }
</script>
<script type="text/javascript">

 $( document ).ready(function() {

$("#search_").on("keyup", function() {
  var SearchCount = 0;
  $('#all_rad2').prop('checked',true);  
  var input = $(this).val().toUpperCase();
  $(".searchCard").each(function() {
    $(this).removeClass('seeCase');
    if ($(this).data("string").toUpperCase().indexOf(input) < 0) {
      $(this).hide();
       $(this).removeClass('seeCase');
    } else {
        SearchCount++;
      $(this).show();
       $(this).addClass('seeCase');
    }
  });
  if(SearchCount == 0){
    $('.no_result').toggleClass('hide');
  }else{
    $('.no_result').addClass('hide');
  }
  apply_pagination2();
});

$("#search_2").on("keyup", function() {
  var SearchCount1 = 0;  
    $('#all_rad').prop('checked',true);  

  var input = $(this).val().toUpperCase();
  $(".searchCard2").each(function() {
    $(this).removeClass('see');
    if ($(this).data("string").toUpperCase().indexOf(input) < 0) {
      $(this).hide();
      $(this).removeClass('see');
      
    } else {
        SearchCount1++;
      $(this).show();
       $(this).addClass('see');
    }
  });
  if(SearchCount1 == 0){
    $('.no_result2').toggleClass('hide');
  }else{
    $('.no_result2').addClass('hide');
  }

  apply_pagination();
});

 //pagination
apply_pagination();
function apply_pagination() {
$('#pagin').empty();
var pageSize = 12;
var incremSlide = 4;
var startPage = 0;
var numberPage = 0;


var pageCount =  $(".see").length / pageSize;
var totalSlidepPage = Math.floor(pageCount / incremSlide);

for(var i = 0 ; i<pageCount;i++){
    $("#pagin").append('<li><a href="#">'+(i+1)+'</a></li> ');
    if(i>pageSize){
       //$("#pagin li").eq(i).hide();
    }
}

var prev = $("<li/>").addClass("prev").html("Prev").click(function(){
   startPage-=5;
   incremSlide-=5;
   numberPage--;
   slide();
});

prev.hide();

var next = $("<li/>").addClass("next").html("Next").click(function(){
   startPage+=5;
   incremSlide+=5;
   numberPage++;
   slide();
});

//$("#pagin").prepend(prev).append(next);

$("#pagin li").first().find("a").addClass("current");

slide = function(sens){
   $("#pagin li").hide();
   
   for(t=startPage;t<incremSlide;t++){
     $("#pagin li").eq(t+1).show();
   }
   if(startPage == 0){
     next.show();
     prev.hide();
   }else if(numberPage == totalSlidepPage ){
     next.hide();
     prev.show();
   }else{
     next.show();
     prev.show();
   }
   
    
    }

    showPage = function(page) {
         $(".see").hide();
         $(".see").each(function(n) {
             if (n >= pageSize * (page - 1) && n < pageSize * page)
                 $(this).show();
         });        
    }
        
    showPage(1);
    $("#pagin li a").eq(0).addClass("current");

    $("#pagin li a").click(function() {
        $("#pagin li a").removeClass("current");
        $(this).addClass("current");
        showPage(parseInt($(this).text()));
    });
}  
apply_pagination2();

function apply_pagination2() {
$('#pagin2').empty();
var pageSize = 20;
var incremSlide = 4;
var startPage = 0;
var numberPage = 0;


var pageCount =  $(".seeCase").length / pageSize;
var totalSlidepPage = Math.floor(pageCount / incremSlide);

for(var i = 0 ; i<pageCount;i++){
    $("#pagin2").append('<li><a href="#">'+(i+1)+'</a></li> ');
    if(i>pageSize){
       $("#pagin2 li").eq(i).hide();
    }
}

var prev = $("<li/>").addClass("prev").html("Prev").click(function(){
   startPage-=5;
   incremSlide-=5;
   numberPage--;
   slide();
});

prev.hide();

var next = $("<li/>").addClass("next").html("Next").click(function(){
   startPage+=5;
   incremSlide+=5;
   numberPage++;
   slide();
});

//$("#pagin").prepend(prev).append(next);

$("#pagin2 li").first().find("a").addClass("current");

slide = function(sens){
   $("#pagin2 li").hide();
   
   for(t=startPage;t<incremSlide;t++){
     $("#pagin2 li").eq(t+1).show();
   }
   if(startPage == 0){
     next.show();
     prev.hide();
   }else if(numberPage == totalSlidepPage ){
     next.hide();
     prev.show();
   }else{
     next.show();
     prev.show();
   }
   
    
    }

    showPage1 = function(page) {
         $(".seeCase").hide();
         $(".seeCase").each(function(n) {
             if (n >= pageSize * (page - 1) && n < pageSize * page)
                 $(this).show();
         });        
    }
        
    showPage1(1);
    $("#pagin2 li a").eq(0).addClass("current");

    $("#pagin2 li a").click(function() {
        $("#pagin2 li a").removeClass("current");
        $(this).addClass("current");
        showPage1(parseInt($(this).text()));
    });
}  

    $('#today_rad,#today_rad2').click(function(){

        if($('#menu1').hasClass('active')){
           var className = 'searchCard';
           var remClass = 'seeCase';
           var togCls = 'no_result'; 
        }else{
           var className = 'searchCard2';
           var remClass = 'see'; 
           var togCls = 'no_result2'; 
        }

        var SearchCount1 = 0;  
      var today = '<?php echo date('Y-m-d'); ?>';   
        $("."+className).each(function() {
          $(this).removeClass(remClass);  
        if ($(this).data("created") != today ) {
          $(this).hide();
          $(this).removeClass(remClass);
        } else {
            SearchCount1++;
          $(this).show();
          $(this).addClass(remClass);
        }
      });
      if(SearchCount1 == 0){
        $('.'+togCls).toggleClass('hide');
      }else{
        $('.'+togCls).addClass('hide');
      }
      if($('#menu1').hasClass('active')){
           apply_pagination2();  
        }else{
           apply_pagination();  
        }
      
    });

     $('#this_month_rad,#this_month_rad2').click(function(){
     var SearchCount1 = 0;  
     var this_month = '<?php echo date('m'); ?>';
        if($('#menu1').hasClass('active')){
           var className = 'searchCard';
           var remClass = 'seeCase';
           var togCls = 'no_result'; 
        }else{
           var className = 'searchCard2';
           var remClass = 'see'; 
           var togCls = 'no_result2'; 
        } 
        $("."+className).each(function() {
        $(this).removeClass(remClass);  
        if ($(this).data("month") != this_month ) {
          $(this).hide();
            $(this).removeClass(remClass);  

        } else {
            SearchCount1++;
            $(this).show();
            $(this).addClass(remClass);  

        }
      });
      if(SearchCount1 == 0){
        $('.'+togCls).toggleClass('hide');
      }else{
        $('.'+togCls).addClass('hide');
      }
      if($('#menu1').hasClass('active')){
           apply_pagination2();  
        }else{
           apply_pagination();  
        }
    });


     $('#last_month_rad,#last_month_rad2').click(function(){
     var SearchCount1 = 0;  
     var last_month = '<?php echo date("m",strtotime("-1 month")); ?>'; 
        if($('#menu1').hasClass('active')){
           var className = 'searchCard';
           var remClass = 'seeCase';
           var togCls = 'no_result'; 
        }else{
           var className = 'searchCard2';
           var remClass = 'see'; 
           var togCls = 'no_result2'; 
        }   
        $("."+className).each(function() {
        $(this).removeClass(remClass);  
        if ($(this).data("month") != last_month ) {
          $(this).hide();
            $(this).removeClass(remClass);  

        } else {
            SearchCount1++;
            $(this).show();
            $(this).addClass(remClass);  

        }
      });
      if(SearchCount1 == 0){
        $('.'+togCls).toggleClass('hide');
      }else{
        $('.'+togCls).addClass('hide');
      }
      if($('#menu1').hasClass('active')){
           apply_pagination2();  
        }else{
           apply_pagination();  
        }
    });
     $('#all_rad,#all_rad2').click(function(){
     var SearchCount1 = 0;  
     if($('#menu1').hasClass('active')){
           var className = 'searchCard';
           var remClass = 'seeCase';
           var togCls = 'no_result'; 
        }else{
           var className = 'searchCard2';
           var remClass = 'see'; 
           var togCls = 'no_result2'; 
        } 
        $("."+className).each(function() {
          $(this).removeClass(remClass);       
          $(this).show();
          $(this).addClass(remClass);  

        });
       if($('#menu1').hasClass('active')){
           apply_pagination2();  
        }else{
           apply_pagination();  
        }  

        //if($('.'+togCls).hasClass('hide')){
            $('.'+togCls).addClass('hide');
       // }
    });

   




   // Case Type
     $('#case_type').change(function(){
     var SearchCount1 = 0;  
     var case_type = $(this).val(); 
     if(case_type != ''){   
        var className = 'searchCard';
           var remClass = 'seeCase';
           var togCls = 'no_result'; 
     
        $("."+className).each(function() {
        $(this).removeClass(remClass);  
        if ($(this).data("case_type") != case_type ) {
          $(this).hide();
          $(this).removeClass(remClass);  

        } else {
            SearchCount1++;
            $(this).show();
            $(this).addClass(remClass);  

        }
      });
      if(SearchCount1 == 0){
        $('.'+togCls).toggleClass('hide');
      }else{
        $('.'+togCls).addClass('hide');
      }

      }else{
        $(".searchCard").each(function() {
        $(this).removeClass('seeCase');  
            SearchCount1++;
            $(this).show();
            $(this).addClass('seeCase');  

        });
        $('.no_result').addClass('hide');
    }
      
    apply_pagination2();  
        
    });


      // Case Type
     $('#c_status').change(function(){
     var SearchCount1 = 0;  
     var c_status = $(this).val(); 
      
     if(c_status != ''){   
        var className = 'searchCard';
        var remClass = 'seeCase';
        var togCls = 'no_result'; 
     
        $("."+className).each(function() {
        $(this).removeClass(remClass);  
        if ($(this).data("cstatus") != c_status ) {
          $(this).hide();
          $(this).removeClass(remClass);  

        } else {
            SearchCount1++;
            $(this).show();
            $(this).addClass(remClass);  

        }
      });
      if(SearchCount1 == 0){
        $('.'+togCls).toggleClass('hide');
      }else{
        $('.'+togCls).addClass('hide');
      }

    }else{
        $(".searchCard").each(function() {
        $(this).removeClass('seeCase');  
            SearchCount1++;
            $(this).show();
            $(this).addClass('seeCase');  

        });
        $('.no_result').addClass('hide');
    }
      
    apply_pagination2();  
        
    });

 });  

 function matter_hearing_report() {
     var fnServerParams = {
        'hearing_type':'[name="hearing_type"]',
        'case_id':'[name="case_id"]',
        "report_to": "[name='report-to']",
        "report_from": "[name='report-from']",
        "clientid": '[name="client_id"]',
        "report_months": '[name="months-report"]',       
    }   
     if ($.fn.DataTable.isDataTable('.table-matter-hearing-report')) {
       $('.table-matter-hearing-report').DataTable().destroy();
     }
     _table_api = initDataTable('.table-matter-hearing-report', admin_url + 'reports/matter_hearing_report', false, false, fnServerParams, [
       [1, 'ASC'],
       [1, 'ASC']
       ]);//.column(3).visible(false, false).columns.adjust();
     $.each(fnServerParams, function(i, obj) {
        $('select' + obj).on('change', function() {
            _table_api.ajax.reload();
        });
    });
     
     $('input[name="report-from"]').on('change',function(){
        _table_api.ajax.reload();
     });

     $('input[name="report-to"]').on('change',function(){
        _table_api.ajax.reload();
     });
   }
</script>