<!--- edit hearing ------------->
<script type="text/javascript">
    
  function hearingTable(tableName,projectID) { 
     var fnServerParams = {  };
     var tableName_ = '.table-'+tableName+'-hearings';
     if ($.fn.DataTable.isDataTable(tableName_)) {
       $(tableName_).DataTable().destroy();
     }
     _table_api = initDataTable(tableName_, admin_url + 'projects/hearings_tables/'+projectID+'/'+tableName, false, false, fnServerParams, [
       [0, 'ASC'],
       [0, 'ASC']
       ]);
  }

</script>
<script type="text/javascript">
   
function init_hearing(id,casetype) {
    if ($('#task-modal').is(':visible')) {
        $('#task-modal').modal('hide');
    }
    // In case header error
    if (init_hearing_modal_data(id, undefined,casetype)) {
        $('#hearing-modal').modal('show');
    }
   }
   // Fetches lead modal data, can be edit/add/view
function init_hearing_modal_data(id, url,casetype) {
    
    var requestURL = (typeof (url) != 'undefined' ? url : 'projects/dashhearing/') + (typeof (id) != 'undefined' ? id : '')+'?casetype='+casetype;
    var str = requestURL;
    var res = str.charAt(str.length-1);
    if(res == '/')
      requestURL += '?hearing_type='+$("#myTab li.active").attr('id');
   

    requestGetJSON(requestURL).done(function (response) {
        _hearing_init_data(response, id);
    }).fail(function (data) {
        alert_float('danger', data.responseText);
    });
}

// Add lead data returned from server to the lead modal
function _hearing_init_data(data, id) {
   
    var hash = window.location.hash;

    var $hearingModal = $('#hearing-modal');
    //$('#lead_reminder_modal').html(data.leadView.reminder_data);

    $hearingModal.find('.data').html(data.leadView.data);

    $hearingModal.modal({
        show: true,
        backdrop: 'static'
    });
    tinymce.remove('#comments');
    init_editor('#comments');
    tinymce.remove('#proceedings');
    init_editor('#proceedings');
    init_selectpicker();
    init_datepicker();
    validate_hearing_form();
}
// Lead form validation
function validate_hearing_form() {
    var validationObject = {
        subject: 'required',
        hearing_date : 'required',
        court_no: 'required',
        project_id : 'required'
    };

    var messages = {};

    appValidateForm($('#hearing-form'), validationObject, hearing_form_handler, messages);
}
// Lead profile data function form handler
function hearing_form_handler(form) {
    form = $(form);
    var data = form.serialize();
    var leadid = $('#hearing-modal').find('input[name="leadid"]').val();
   $('#proceedings').val(tinyMCE.get('proceedings').getContent());
   $('#comments').val(tinyMCE.get('comments').getContent());
    //$('.lead-save-btn').addClass('disabled');
    $.post(form.attr('action'), data).done(function (response) {
        response = JSON.parse(response);
        if (response.message !== '') {
            alert_float('success', response.message);
        }
        if (response.proposal_warning && response.proposal_warning != false) {
            $("body").find('#lead_proposal_warning').removeClass('hide');
            $("body").find('#lead-modal').animate({
                scrollTop: 0
            }, 800);
        } else {
            matter_hearing_report();
			 matter_arbitrationhearing_report();
            $('#hearing-modal').modal('hide');
        }
        
    }).fail(function (data) {
        alert_float('danger', data.responseText);
        return false;
    });
    return false;
}
</script>