<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
   <?php echo form_hidden('project_id',$project->id) ?>
   <div class="content">
      <div class="row">
         <div class="col-md-12">
            <div class="panel_s project-top-panel panel-full">
               <div class="panel-body _buttons">
                  <div class="row">
                     <div class="col-md-7 project-heading">
                        <h3 class="hide project-name"><?php echo $project->name; ?></h3>
                        <div id="project_view_name" class="pull-left">
                           <select class="selectpicker" id="project_top" data-width="100%"<?php if(count($other_projects) > 6){ ?> data-live-search="true" <?php } ?>>
                              <option value="<?php echo $project->id; ?>" selected data-content="<?php echo $project->name; ?> - <small><?php echo $project->client_data->company; ?></small>">
                                <?php echo $project->client_data->company; ?> <?php echo $project->name; ?>
                              </option>
                              <?php foreach($other_projects as $op){ ?>
                              <option value="<?php echo $op['id']; ?>" data-subtext="<?php echo $op['company']; ?>">#<?php echo $op['id']; ?> - <?php echo $op['name']; ?></option>
                              <?php } ?>
                           </select>
                        </div>
                        <div class="visible-xs">
                           <div class="clearfix"></div>
                        </div>
                        <?php echo '<div class="label pull-left mleft15 mtop8 p8 project-status-label-'.$project->status.'" style="background:'.$project_status['color'].'">'.$project_status['name'].'</div>'; ?>
                     </div>
                     <div class="col-md-5 text-right">
                        <?php if(has_permission('tasks','','create')){ ?>
                        <a href="#" onclick="new_task_from_relation(undefined,'project',<?php echo $project->id; ?>); return false;" class="btn btn-info"><?php echo _l('new_task'); ?></a>
                        <?php } ?>
                        <?php
                           $invoice_func = 'pre_invoice_project';
                           ?>
                        <?php if(has_permission('invoices','','create')){ ?>
                        <a href="#" onclick="<?php echo $invoice_func; ?>(<?php echo $project->id; ?>); return false;" class="invoice-project btn btn-info<?php if($project->client_data->active == 0){echo ' disabled';} ?>"><?php echo _l('invoice_project'); ?></a>
                        <?php } ?>
                        <?php
                           $project_pin_tooltip = _l('pin_project');
                           if(total_rows(db_prefix().'pinned_projects',array('staff_id'=>get_staff_user_id(),'project_id'=>$project->id)) > 0){
                             $project_pin_tooltip = _l('unpin_project');
                           }
                           ?>
                        <div class="btn-group">
                           <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                           <?php echo _l('more'); ?> <span class="caret"></span>
                           </button>
                           <ul class="dropdown-menu dropdown-menu-right width200 project-actions">
                              <li>
                                 <a href="<?php echo admin_url('projects/pin_action/'.$project->id); ?>">
                                 <?php echo $project_pin_tooltip; ?>
                                 </a>
                              </li>
                              <?php if(has_permission('projects','','edit')){ ?>
                              <li>
                                 <a href="<?php echo admin_url('projects/project/'.$project->id); ?>">
                                 <?php echo _l('edit_project'); ?>
                                 </a>
                              </li>
                              <?php } ?>
                              <?php if(has_permission('projects','','create')){ ?>
                              <li>
                                 <a href="#" onclick="copy_project(); return false;">
                                 <?php echo _l('copy_project'); ?>
                                 </a>
                              </li>
                              <?php } ?>
                              <?php if(has_permission('projects','','create') || has_permission('projects','','edit')){ ?>
                              <li class="divider"></li>
                              <?php foreach($statuses as $status){
                                 if($status['id'] == $project->status){continue;}
                                 ?>
                              <li>
                                 <a href="#" data-name="<?php echo _l('project_status_'.$status['id']); ?>" onclick="project_mark_as_modal(<?php echo $status['id']; ?>,<?php echo $project->id; ?>, this); return false;"><?php echo _l('project_mark_as',$status['name']); ?></a>
                              </li>
                              <?php } ?>
                              <?php } ?>
                              <li class="divider"></li>
                              <?php if(has_permission('projects','','create')){ ?>
                              <li>
                                 <a href="<?php echo admin_url('projects/export_project_data/'.$project->id); ?>" target="_blank"><?php echo _l('export_project_data'); ?></a>
                              </li>
                              <?php } ?>
                              <?php if(is_admin()){ ?>
                              <li>
                                 <a href="<?php echo admin_url('projects/view_project_as_client/'.$project->id .'/'.$project->clientid); ?>" target="_blank"><?php echo _l('project_view_as_client'); ?></a>
                              </li>
                              <?php } ?>
                              <?php if(has_permission('projects','','delete')){ ?>
                              <li>
                                 <a href="<?php echo admin_url('projects/delete/'.$project->id); ?>" class="_delete">
                                 <span class="text-danger"><?php echo _l('delete_project'); ?></span>
                                 </a>
                              </li>
                              <?php } ?>
                           </ul>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="panel_s project-menu-panel">
               <div class="panel-body">
                  <?php hooks()->do_action('before_render_project_view', $project->id); ?>
                  <?php $this->load->view('admin/projects/project_tabs'); ?>
               </div>
            </div>
            <?php
               if((has_permission('projects','','create') || has_permission('projects','','edit'))
                 && $project->status == 1
                 && $this->projects_model->timers_started_for_project($project->id)
                 && $tab['slug'] != 'project_milestones') {
               ?>
            <div class="alert alert-warning project-no-started-timers-found mbot15">
               <?php echo _l('project_not_started_status_tasks_timers_found'); ?>
            </div>
            <?php } ?>
            <?php
               if($project->deadline && date('Y-m-d') > $project->deadline
                && $project->status == 2
                && $tab['slug'] != 'project_milestones') {
               ?>
            <div class="alert alert-warning bold project-due-notice mbot15">
               <?php echo _l('project_due_notice', floor((abs(time() - strtotime($project->deadline)))/(60*60*24))); ?>
            </div>
            <?php } ?>
            <?php
               if(!has_contact_permission('projects',get_primary_contact_user_id($project->clientid))
                 && total_rows(db_prefix().'contacts',array('userid'=>$project->clientid)) > 0
                 && $tab['slug'] != 'project_milestones') {
               ?>
            <div class="alert alert-warning project-permissions-warning mbot15">
               <?php echo _l('project_customer_permission_warning'); ?>
            </div>
            <?php } ?>
            <div class="panel_s">
               <div class="panel-body">
                  <?php $this->load->view(($tab ? $tab['view'] : 'admin/projects/project_overview')); ?>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
</div>
</div>
<?php if(isset($discussion)){
   echo form_hidden('discussion_id',$discussion->id);
   echo form_hidden('discussion_user_profile_image_url',$discussion_user_profile_image_url);
   echo form_hidden('current_user_is_admin',$current_user_is_admin);
   }
   echo form_hidden('project_percent',$percent);
     echo form_hidden('customer_id',$project->clientid);
 
   ?>
<div id="invoice_project"></div>
<div id="pre_invoice_project"></div>
<?php $this->load->view('admin/projects/milestone'); ?>
<?php $this->load->view('admin/projects/copy_settings'); ?>
<?php $this->load->view('admin/projects/_mark_tasks_finished'); ?>
<?php init_tail(); ?>
<!-- For invoices table -->
<script>
   taskid = '<?php echo $this->input->get('taskid'); ?>';
</script>
<script>
   var gantt_data = {};
   <?php if(isset($gantt_data)){ ?>
   gantt_data = <?php echo json_encode($gantt_data); ?>;
   <?php } ?>
   var discussion_id = $('input[name="discussion_id"]').val();
   var discussion_user_profile_image_url = $('input[name="discussion_user_profile_image_url"]').val();
   var current_user_is_admin = $('input[name="current_user_is_admin"]').val();
   var project_id = $('input[name="project_id"]').val();
   if(typeof(discussion_id) != 'undefined'){
     discussion_comments('#discussion-comments',discussion_id,'regular');
   }
   $(function(){
    var project_progress_color = '<?php echo hooks()->apply_filters('admin_project_progress_color','#84c529'); ?>';
    var circle = $('.project-progress').circleProgress({fill: {
     gradient: [project_progress_color, project_progress_color]
   }}).on('circle-animation-progress', function(event, progress, stepValue) {
     $(this).find('strong.project-percent').html(parseInt(100 * stepValue) + '<i>%</i>');
   });
   });

   function discussion_comments(selector,discussion_id,discussion_type){
     var defaults = _get_jquery_comments_default_config(<?php echo json_encode(get_project_discussions_language_array()); ?>);
     var options = {
      // https://github.com/Viima/jquery-comments/pull/169
      wysiwyg_editor: {
            opts: {
                enable: true,
                is_html: true,
                container_id: 'editor-container',
                comment_index: 0,
            },
            init: function (textarea, content) {
                var comment_index = textarea.data('comment_index');
                 var editorConfig = _simple_editor_config();
                 editorConfig.setup = function(ed) {
                      textarea.data('wysiwyg_editor', ed);

                      ed.on('change', function() {
                          var value = ed.getContent();
                          if (value !== ed._lastChange) {
                            ed._lastChange = value;
                            textarea.trigger('change');
                          }
                      });

                      ed.on('keyup', function() {
                        var value = ed.getContent();
                          if (value !== ed._lastChange) {
                            ed._lastChange = value;
                            textarea.trigger('change');
                          }
                      });

                      ed.on('Focus', function (e) {
                        setTimeout(function(){
                          textarea.trigger('click');
                        }, 500)
                      });

                      ed.on('init', function() {
                        if (content) ed.setContent(content);

                        if ($('#mention-autocomplete-css').length === 0) {
                              $('<link>').appendTo('head').attr({
                                 id: 'mention-autocomplete-css',
                                 type: 'text/css',
                                 rel: 'stylesheet',
                                 href: site_url + 'assets/plugins/tinymce/plugins/mention/autocomplete.css'
                              });
                           }

                           if ($('#mention-css').length === 0) {
                              $('<link>').appendTo('head').attr({
                                 type: 'text/css',
                                 id: 'mention-css',
                                 rel: 'stylesheet',
                                 href: site_url + 'assets/plugins/tinymce/plugins/mention/rte-content.css'
                              });
                           }
                      })
                  }

                  editorConfig.plugins[0] += ' mention';
                  editorConfig.content_style = 'span.mention {\
                     background-color: #eeeeee;\
                     padding: 3px;\
                  }';
                  var projectUserMentions = [];
                  editorConfig.mentions = {
                     source: function (query, process, delimiter) {
                           if (projectUserMentions.length < 1) {
                              $.getJSON(admin_url + 'projects/get_staff_names_for_mentions/' + project_id, function (data) {
                                 projectUserMentions = data;
                                 process(data)
                              });
                           } else {
                              process(projectUserMentions)
                           }
                     },
                     insert: function(item) {
                           return '<span class="mention" contenteditable="false" data-mention-id="'+ item.id + '">@'
                           + item.name + '</span>&nbsp;';
                     }
                  };

                var containerId = this.get_container_id(comment_index);
                tinyMCE.remove('#'+containerId);

                setTimeout(function(){
                  init_editor('#'+ containerId, editorConfig)
                },100)
            },
            get_container: function (textarea) {
                if (!textarea.data('comment_index')) {
                    textarea.data('comment_index', ++this.opts.comment_index);
                }

                return $('<div/>', {
                    'id': this.get_container_id(this.opts.comment_index)
                });
            },
            get_contents: function(editor) {
               return editor.getContent();
            },
            on_post_comment: function(editor, evt) {
               editor.setContent('');
            },
            get_container_id: function(comment_index) {
              var container_id = this.opts.container_id;
              if (comment_index) container_id = container_id + "-" + comment_index;
              return container_id;
            }
        },
      currentUserIsAdmin:current_user_is_admin,
      getComments: function(success, error) {
        $.get(admin_url + 'projects/get_discussion_comments/'+discussion_id+'/'+discussion_type,function(response){
          success(response);
        },'json');
      },
      postComment: function(commentJSON, success, error) {
        $.ajax({
          type: 'post',
          url: admin_url + 'projects/add_discussion_comment/'+discussion_id+'/'+discussion_type,
          data: commentJSON,
          success: function(comment) {
            comment = JSON.parse(comment);
            success(comment)
          },
          error: error
        });
      },
      putComment: function(commentJSON, success, error) {
        $.ajax({
          type: 'post',
          url: admin_url + 'projects/update_discussion_comment',
          data: commentJSON,
          success: function(comment) {
            comment = JSON.parse(comment);
            success(comment)
          },
          error: error
        });
      },
      deleteComment: function(commentJSON, success, error) {
        $.ajax({
          type: 'post',
          url: admin_url + 'projects/delete_discussion_comment/'+commentJSON.id,
          success: success,
          error: error
        });
      },
      uploadAttachments: function(commentArray, success, error) {
        var responses = 0;
        var successfulUploads = [];
        var serverResponded = function() {
          responses++;
            // Check if all requests have finished
            if(responses == commentArray.length) {
                // Case: all failed
                if(successfulUploads.length == 0) {
                  error();
                // Case: some succeeded
              } else {
                successfulUploads = JSON.parse(successfulUploads);
                success(successfulUploads)
              }
            }
          }
          $(commentArray).each(function(index, commentJSON) {
            // Create form data
            var formData = new FormData();
            if(commentJSON.file.size && commentJSON.file.size > app.max_php_ini_upload_size_bytes){
             alert_float('danger',"<?php echo _l("file_exceeds_max_filesize"); ?>");
             serverResponded();
           } else {
            $(Object.keys(commentJSON)).each(function(index, key) {
              var value = commentJSON[key];
              if(value) formData.append(key, value);
            });

            if (typeof(csrfData) !== 'undefined') {
               formData.append(csrfData['token_name'], csrfData['hash']);
            }
            $.ajax({
              url: admin_url + 'projects/add_discussion_comment/'+discussion_id+'/'+discussion_type,
              type: 'POST',
              data: formData,
              cache: false,
              contentType: false,
              processData: false,
              success: function(commentJSON) {
                successfulUploads.push(commentJSON);
                serverResponded();
              },
              error: function(data) {
               var error = JSON.parse(data.responseText);
               alert_float('danger',error.message);
               serverResponded();
             },
           });
          }
        });
        }
      }
      var settings = $.extend({}, defaults, options);
    $(selector).comments(settings);
   }
</script>
</body>
</html>
<script type="text/javascript">
  function hearingTable(tableName,projectID) {
     var fnServerParams = {  };
     var tableName_ = '.table-'+tableName+'-hearings';
     if ($.fn.DataTable.isDataTable(tableName_)) {
       $(tableName_).DataTable().destroy();
     }
     _table_api = initDataTable(tableName_, admin_url + 'projects/hearings_tables/'+projectID+'/'+tableName, false, false, fnServerParams, [
       [0, 'ASC'],
       [0, 'ASC']
       ]);
  }
</script>
<script type="text/javascript">
  var hearingTypeGlobal = 'first_instance';

  function courtClick(courtname,courtid) { 
     //$("label[for='court_no']").text('Hearing No ('+courtname+' No )');
     alert(courtname);
     if(courtname != 'All')
     $('#btn_add_hearing').text('ADD '+courtname);
    /*if(courtname == 'First Instance' || courtid == 'first_instance'){ 
      $("label[for='court_no']").text("First Instance No");
      $('#btn_add_hearing').text('ADD FIRST INSTANCE');
    }else if(courtname == 'Appeal' || courtid == 'appeal'){
      $("label[for='court_no']").text("Appeal No");
      $('#btn_add_hearing').text('ADD APPEAL');
    }else if(courtname == 'Cassation' || courtid == 'cassation'){
      $("label[for='court_no']").text("Cassation No");
      $('#btn_add_hearing').text('ADD CASSATION');
    }else if(courtname == 'Execution Appeal' || courtid == 'execution_appeal'){
      $("label[for='court_no']").text("Execution Appeal No");
      $('#btn_add_hearing').text('ADD EXECUTION APPEAL');
    }else if(courtname == 'Execution' || courtid == 'execution'){
      $("label[for='court_no']").text("Execution No");
      $('#btn_add_hearing').text('ADD EXECUTION');
    }else if(courtname == 'Small Claim' || courtid == 'small_claim'){
      $("label[for='court_no']").text("Small Claim No");
      $('#btn_add_hearing').text('ADD SMALL CLAIM');
    }*/

    //var ctype = $("#hearing-form :input[name='hearing_type']");

    $('#hearing-form input[name="hearing_type"]').val(courtid); 
    hearingTypeGlobal = courtid;
    $('.edit_hearing').css('display','none'); 
    hearingTable(courtid,<?php echo $project->id;?>);
  }

 courtClick('<?php echo _l($hearing_type_tab); ?>', '<?php echo $hearing_type_tab; ?>');
</script>
<script>var hidden_columns = [5,6,7];</script>

<script type="text/javascript">
  /*_validate_form($('#case-form'),{file_no:'required',case_number:'required',case_title:'required'},$('#case-form'));*/

  /*function init_hearing(hearingid=''){
   
    $('#hearing').modal('show');
    $('#hearing .edit-title').addClass('hide');

  }*/


  $('#btn_add_hearing').click(function(){
    $('.edit_hearing').hide();
  });

  function show_edit_form(formDivID){
    $('#demo').removeClass('in');
    $('#demo').attr("aria-expanded","false");
    $('.edit_hearing').hide();
    $(formDivID).show();
  }

  function setHearingId(hearingId){
    $('#hid_hearing_id').val(hearingId);
  }


  function toggle_small_view__(table, main_data,table_wr) { 

    $("body").toggleClass('small-table');
    var tablewrap = $(table_wr);
    if (tablewrap.length === 0) {
        return;
    }
    var _visible = false;
    if (tablewrap.hasClass('col-md-4')) {
        tablewrap.removeClass('col-md-4').addClass('col-md-12');
        _visible = true;
        $('.toggle-small-view').find('i').removeClass('fa fa-angle-double-right').addClass('fa fa-angle-double-left');
    } else {
        tablewrap.addClass('col-md-4').removeClass('col-md-12');
        $('.toggle-small-view').find('i').removeClass('fa fa-angle-double-left').addClass('fa fa-angle-double-right');
    }
    var _table = $(table).DataTable();
    // Show hide hidden columns
    _table.columns(hidden_columns).visible(_visible, false);
    _table.columns.adjust();
    $(main_data).toggleClass('hide');
    $(window).trigger('resize');
}

// Init single proposal
function init_hearing(id,selector1,tablename,div) { 
    load_small_table_item_(id, selector1, 'hearing_id', 'casediary/get_case_data_ajax', tablename,div);
}

function load_small_table_item_(id, selector, input_name, url, table,div) {
    var _tmpID = $('input[name="' + input_name + '"]').val();
    // Check if id passed from url, hash is prioritized becuase is last
   /* if (_tmpID !== '' && !window.location.hash) {
        id = _tmpID;
        // Clear the current id value in case user click on the left sidebar credit_note_ids
        $('input[name="' + input_name + '"]').val('');
    } else {
        // check first if hash exists and not id is passed, becuase id is prioritized
        if (window.location.hash && !id) {
            id = window.location.hash.substring(1); //Puts hash in variable, and removes the # character
        }
    }
    if (typeof (id) == 'undefined' || id === '') { 
        return;
    }*/
    destroy_dynamic_scripts_in_element($(selector))
    if (!$("body").hasClass('small-table')) { 
        toggle_small_view__(table, selector,div);
    }
    //$('input[name="' + input_name + '"]').val(id);
    do_hash_helper(id);
    $(selector).load(admin_url + url + '/' + id);
    if (is_mobile()) {
        $('html, body').animate({
            scrollTop: $(selector).offset().top + 150
        }, 600);
    }
}

 function edit_scope(id) {
    var description = $("body").find('[data-note-edit-textarea="' + id + '"] textarea').val();
    if (description != '') {
        $.post(admin_url + 'casediary/edit_scope/' + id, {
            description: description
        }).done(function(response) {
            response = JSON.parse(response);
            if (response.success == true) {
                alert_float('success', response.message);
                $("body").find('[data-note-description="' + id + '"]').html(nl2br(description));
            }
        });
        toggle_edit_note(id);
    }
    }
function setHearingId(hearingId){
    $('#hid_hearing_id').val(hearingId);
  }

var formatter = new Intl.NumberFormat('en-US', {
  style: 'currency',
  currency: 'AED',

  // These options are needed to round to whole numbers if that's what you want.
  //minimumFractionDigits: 0, // (this suffices for whole numbers, but will print 2500.10 as $2,500.1)
  //maximumFractionDigits: 0, // (causes 2500.99 to be printed as $2,501)
});

$('input[name="claiming_amount"]').blur(function(){ 
   var amnt = $(this).val();
   var amnt = amnt.replaceAll("AED", "");
   var amnt = amnt.replaceAll(",","");
   var amnt = parseFloat(amnt);
  
  /* var s = (amnt).toLocaleString('en-US', {
     style: 'currency',
     currency: 'AED',
   });
   alert(s);*/
   var s = formatter.format(amnt);

   $(this).val(s);
});

</script>

<script type="text/javascript">
    get_expense_advance_();
     function get_expense_advance_(){ 
        $('#span_expense_').html('');
        var customer_id = <?php echo $project->clientid; ?>;
        if(customer_id){
        $.get(admin_url + 'expenses/get_customer_change_data/'+customer_id,function(response2){
          var res = JSON.parse(response2);
         if(res['customer_has_expense_deposit']){ 
            //$('#span_expense_').addClass('hide');
            //$('#span_expense_').removeClass('hide');
            $('#span_expense_').html('<b>Current Balance : '+res['customer_has_expense_deposit']+'</b>');
         }
      });
     }
     }  
</script>

<script type="text/javascript">
   /*function validate_hearing_form(){
      _validate_form($('#hearing-form'),{subject:'required',hearing_date:'required',court_no:'required'});
   }
   validate_hearing_form();
   $('#hearing-form').submit(function (e) {
      validate_hearing_form();
      e.preventDefault();
      $('#proceedings').val(tinyMCE.get('proceedings').getContent());
      $('#comments').val(tinyMCE.get('comments').getContent());
         $.ajax({
            type: 'post',
            url:  $('#hearing-form').attr('action'),
            data: $('#hearing-form').serialize(),
            success: function (response) {
               console.log(response);
               response = JSON.parse(response);
               if(response.success == true){ 
                  alert_float('success',response.message);
                  $('#hearing-form').trigger("reset");
                  $('#btn_hearing_form').removeClass('disabled');
                  $('#btn_hearing_form').attr('disabled',false);
                  $('#btn_hearing_form').attr('data-loading-text','<?php echo _l('save'); ?>');
                  $('#btn_hearing_form').html('<?php echo _l('save'); ?>');
               }
               
               hearingTable(response.hearing_type,<?php echo $project->id;?>);

            }
         });
         
   
      return false;
   })
      */

  
</script>

<!--- edit hearing ------------->
<script type="text/javascript">
   
function init_hearing(id, project_id) {
    if ($('#task-modal').is(':visible')) {
        $('#task-modal').modal('hide');
    }

    // In case header error
    if (init_hearing_modal_data(id, undefined, project_id)) {
        $('#hearing-modal').modal('show');
    }
   }
   // Fetches lead modal data, can be edit/add/view
function init_hearing_modal_data(id, url, project_id) {
    
    var requestURL = (typeof (url) != 'undefined' ? url : 'projects/hearing/') + (typeof (id) != 'undefined' ? id : '');
    

    requestGetJSON(requestURL).done(function (response) {
        _hearing_init_data(response, id,project_id);
    }).fail(function (data) {
        alert_float('danger', data.responseText);
    });
}

// Add lead data returned from server to the lead modal
function _hearing_init_data(data, id,project_id) {
   
    var hash = window.location.hash;

    var $hearingModal = $('#hearing-modal');
    //$('#lead_reminder_modal').html(data.leadView.reminder_data);

    $hearingModal.find('.data').html(data.leadView.data);
    $hearingModal.find('input.project_id').val(project_id);
    
    $hearingModal.find('input.hearing_type_c').val(hearingTypeGlobal);
    

    $hearingModal.modal({
        show: true,
        backdrop: 'static'
    });
    tinymce.remove('#comments');
    init_editor('#comments');
    tinymce.remove('#proceedings');
    init_editor('#proceedings');
    init_selectpicker();
    init_datepicker();
    validate_hearing_form();
}
// Lead form validation
function validate_hearing_form() {
    var validationObject = {
        subject: 'required',
        hearing_date : 'required',
        court_no: 'required',
    };

    var messages = {};

    appValidateForm($('#hearing-form'), validationObject, hearing_form_handler, messages);
}
// Lead profile data function form handler
function hearing_form_handler(form) {
    form = $(form);
    var data = form.serialize();
    var leadid = $('#hearing-modal').find('input[name="leadid"]').val();
   $('#proceedings').val(tinyMCE.get('proceedings').getContent());
   $('#comments').val(tinyMCE.get('comments').getContent());
    //$('.lead-save-btn').addClass('disabled');
    $.post(form.attr('action'), data).done(function (response) {
        response = JSON.parse(response);
        if (response.message !== '') {
            alert_float('success', response.message);
        }
        if (response.proposal_warning && response.proposal_warning != false) {
            $("body").find('#lead_proposal_warning').removeClass('hide');
            $("body").find('#lead-modal').animate({
                scrollTop: 0
            }, 800);
        } else {
            _hearing_init_data(response, response.id);
        }
        //if ($.fn.DataTable.isDataTable('.table-leads')) {
            hearingTable(response.hearing_type,<?php echo $project->id;?>);
        //} 
    }).fail(function (data) {
        alert_float('danger', data.responseText);
        return false;
    });
    return false;
}
</script>