<!---  court instance ------------->
<script type="text/javascript">
   
function init_payment_schedule(id) { 
    if ($('#task-modal').is(':visible')) {
        $('#task-modal').modal('hide');
    }
    // In case header error
    if (init_payment_schedule_modal_data(id, undefined)) {
        $('#payment-schedule-modal').modal('show');
    }
   }
   // Fetches  modal data, can be edit/add/view
function init_payment_schedule_modal_data(id, url) {
    
    var requestURL = (typeof (url) != 'undefined' ? url : 'casediary/payment_schedule/') + (typeof (id) != 'undefined' ? id : '');
    requestGetJSON(requestURL).done(function (response) {
        _payment_schedule_init_data(response, id);
    }).fail(function (data) {
        alert_float('danger', data.responseText);
    });
}

// Add lead data returned from server to the lead modal
function _payment_schedule_init_data(data, id) {
    var hash = window.location.hash;

    var $hearingModal = $('#payment-schedule-modal');
    //$('#lead_reminder_modal').html(data.leadView.reminder_data);

    $hearingModal.find('.data').html(data.leadView.data);
    $hearingModal.find('input.project_id').val(project_id);
    //$hearingModal.find('div.total_rate').html('<span class="badge"><?php echo _l('project_total_cost').' :'.$project->project_cost;?></span>');

    $hearingModal.modal({
        show: true,
        backdrop: 'static'
    });
    init_selectpicker();
    init_datepicker();
    validate_payment_schedule_form();
}
// Lead form validation
function validate_payment_schedule_form() {
    var validationObject = {
        p_description: 'required',
        p_date : 'required',
        p_amount: 'required',
        p_status: 'required',
    };

    var messages = {};

    appValidateForm($('#payment-schedule-form'), validationObject, payment_schedule_form_handler, messages);
}
// Lead profile data function form handler
function payment_schedule_form_handler(form) {
    form = $(form);
    var data = form.serialize();
    var leadid = $('#payment-schedule-modal').find('input[name="leadid"]').val();
    $('#btn_payment_schedule').addClass('disabled');
    $.post(form.attr('action'), data).done(function (response) {
        response = JSON.parse(response);
        if (response.message !== '') {
            alert_float('success', response.message);
        }
        if (response.proposal_warning && response.proposal_warning != false) {
            $("body").find('#lead_proposal_warning').removeClass('hide');
            $("body").find('#lead-modal').animate({
                scrollTop: 0
            }, 800);
        } else {
            //_payment_schedule_init_data(response, response.id);
            window.location.reload();
        }
        
    }).fail(function (data) {
        alert_float('danger', data.responseText);
        return false;
    });
    return false;
}

</script>