<?php defined('BASEPATH') or exit('No direct script access allowed');

$table_data = [
   _l('the_number_sign'),
   _l('project_name'),
   _l('casediary_file_no'),
    [
         'name'     => _l('case_type'),
		'th_attrs' => ['class' => isset($client) ? '' : 'not_visible'],
    ],
   
    [
         'name'     => _l('project_customer'),
         'th_attrs' => ['class' => (isset($client) && !isset($oppositeparty_)) ? 'not_visible' : ''],
    ],
    [
         'name'     => _l('opposite_party'),
         'th_attrs' => ['class' => isset($oppositeparty_) ? 'not_visible' : ''],
    ],
    [
         'name'     => _l('tags'),
         'th_attrs' => ['class' =>  'not_visible' ],
    ],
   _l('project_start_date'),
   [
         'name'     => _l('project_deadline'),
         'th_attrs' => ['class' =>  'not_visible' ],
    ],
   _l('project_members'),
   _l('project_status'),
];

$custom_fields = get_custom_fields('projects', ['show_on_table' => 1]);
foreach ($custom_fields as $field) {
    array_push($table_data, $field['name']);
}

$table_data = hooks()->apply_filters('projects_table_columns', $table_data);

render_datatable($table_data, isset($class) ?  $class : 'projects', [], [
  'data-last-order-identifier' => 'projects',
  'data-default-order'  => get_table_last_order('projects'),
]);
