<?php
defined('BASEPATH') or exit('No direct script access allowed');

$hasPermissionDelete = has_permission('opposite_parties', '', 'delete');

 
$aColumns = array(
    'tbloppositeparty.id as id',
    'name',
    'firstname',
    'lastname',
    '(SELECT GROUP_CONCAT(company SEPARATOR "\n") FROM tblclients LEFT JOIN tblclient_oppositeparty_rel ON  tblclients.userid = tblclient_oppositeparty_rel.client_id  where tbloppositeparty.id = tblclient_oppositeparty_rel.opposite_party_id) as clients',   
    'opposite_party_file_no',
    'email',
    'mobile',
    'tbloppositeparty.city as city',
    );

$sIndexColumn = "id";
$sTable       = 'tbloppositeparty';
$where   = array('');
// Add blank where all filter can be stored
$filter  = array(' ');

$join = array();

if ($clientid != '') {
   //array_push($where, 'AND client_id=' . $this->ci->db->escape_str($clientid));
    array_push($where, 'AND tbloppositeparty.id IN (SELECT opposite_party_id FROM tblclient_oppositeparty_rel WHERE tblclient_oppositeparty_rel.client_id=' . $this->ci->db->escape_str($clientid) . ')');
}


//$aColumns = do_action('customers_table_sql_columns', $aColumns);


$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where);

$output  = $result['output'];
$rResult = $result['rResult'];
//print_r($rResult);
foreach ($rResult as $aRow) {

    $row = array();

    // Bulk actions
    $row[] = $aRow['id'];
    // User id

    $row[] = '<a href="' . admin_url('opposite_parties/opposite_party/' . $aRow['id']) . '">' . $aRow['name'] . '</a>';

    $row[] = $aRow['firstname']; 
    $row[] = $aRow['lastname']; 
    $row[] = nl2br($aRow['clients']) ;
    $row[] = $aRow['opposite_party_file_no']; 

    // Primary contact email
    $row[] = ($aRow['email'] ? '<a href="mailto:' . $aRow['email'] . '">' . $aRow['email'] . '</a>' : '');

    // Primary contact phone
    $row[] = ($aRow['mobile'] ? '<a href="tel:' . $aRow['mobile'] . '">' . $aRow['mobile'] . '</a>' : '');

   

    //$row[] = $groupsRow;
    $row[] = $aRow['city'];
   
    /*$hook = do_action('customers_table_row_data', array(
        'output' => $row,
        'row' => $aRow
    ));

    $row = $hook['output'];*/

    // Table options
    $options = icon_btn('opposite_parties/opposite_party/' . $aRow['id'], 'pencil-square-o');

    // Show button delete if permission for delete exists
    if ($hasPermissionDelete) {
        $options .= icon_btn('opposite_parties/delete/' . $aRow['id'], 'remove', 'btn-danger _delete');
    }

    $row[] = $options;
    $output['aaData'][] = $row;
}
