<div class="modal fade" id="model_trust_account" tabindex="-1" role="dialog" style="z-index:99999;">
    <div class="modal-dialog">
        <?php echo form_open(admin_url('trust_accounting/trust_account'), array('id'=>'trust-account-form')); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?php echo _l('trust_account_edit'); ?></span>
                    <span class="add-title"><?php echo _l('new_trust_account'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <?php echo render_input('trust_account_name', 'contract_type_name'); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
            </div>
        </div><!-- /.modal-content -->
        <?php echo form_close(); ?>
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<script>
  window.addEventListener('load',function(){
      _validate_form($('#trust-account-form'),{trust_account_name:'required'},manage_courts_types);
      $('#model_trust_account').on('hidden.bs.modal', function(event) {
        $('#additional').html('');
        $('#model_trust_account input[name="trust_account_name"]').val('');
        $('.add-title').removeClass('hide');
        $('.edit-title').removeClass('hide');
    });
  });
  function manage_courts_types(form) {
    var data = $(form).serialize();
    var url = form.action;
    $.post(url, data).done(function(response) {
        response = JSON.parse(response);
        if(response.success == true){ 
            alert_float('success',response.message);
            if(($('body').hasClass('trust_accounting ')) && typeof(response.id) != 'undefined') {
                var ctype = $('#court_id');
                ctype.find('option:first').after('<option value="'+response.id+'">'+response.name+'</option>');
                ctype.selectpicker('val',response.id);
                ctype.selectpicker('refresh');
            }
        }
        if($.fn.DataTable.isDataTable('.table-trust-accounts')){
            $('.table-trust-accounts').DataTable().ajax.reload();
        }
        $('#model_trust_account').modal('hide');
    });
    return false;
}
function new_trust_account(){
    $('#model_trust_account').modal('show');
    $('.edit-title').addClass('hide');
}
function edit_trust_account(invoker,id){
    var name = $(invoker).data('name');
    $('#additional').append(hidden_input('id',id));
    $('#model_trust_account input[name="trust_account_name"]').val(name);
    $('#model_trust_account').modal('show');
    $('.add-title').addClass('hide');
}
</script>
