<?php 
$dimensions = $pdf->getPageDimensions();
// set some language dependent data:
$lg = Array();
$lg['a_meta_charset'] = 'UTF-8';
$lg['a_meta_dir'] = 'rtl';
$lg['a_meta_language'] = 'fa';
$lg['w_page'] = 'page';

// set some language-dependent strings (optional)
$pdf->setLanguageArray($lg);
$pdf->setRTL(true);


// Get Y position for the separation
$y = $pdf->getY();
$pdf_logo_url = pdf_logo_url();
$organizaion_info = '<div style="color:#424242;">';
//$organizaion_info .= format_organization_info();
$organizaion_info .= '</div>';
//$pdf->writeHTMLCell(278, '', '', '', $pdf_logo_url, 0, 1, false, true, 'J', true);
$pdf->Ln(2);
$pdf->SetFont($font_name, '', 8);
$tblhtml ='';
$tblhtml .= '<p align="center"><h2><b style="background-color:#f0f0f0;">'.ucwords(_l('arbitration_report')).'</b></h2></p> <br> '._l('clients_invoice_dt_date')." : ".$hearing[0]['from_date'];
$tblhtml .= '<br><br><table width="100%" bgcolor="#fff" cellspacing="0" cellpadding="5" border="1" style="width:100%; margin:5px;">';
$tblhtml .= '<thead>';

$tblhtml .= '<tr bgcolor="#323a45" style="color:#ffffff;">';

$tblhtml .= '<th  style="text-align:center;"><b>'._l('file_no').'</b></th>';
$tblhtml .= '<th style="text-align:center;"><b>'._l('casediary_casenumber').'</b></th>';
$tblhtml .= '<th  style="text-align:center;"><b>'._l('project_customer').'</b></th>';
$tblhtml .= '<th  style="text-align:center;"><b>'._l('casediary_oppositeparty').'</b></th>';
if(get_option('enable_lawyer_in_role_report') == 1){
$tblhtml .= '<th  style="text-align:center;"><b>'._l('lawyer_attending').'</b></th>';
}
$tblhtml .= '<th  style="text-align:center;"><b>'._l('hearing_court').'</b></th>';
$tblhtml .= '<th  style="text-align:center;"><b>'._l('arbitration_type').'</b></th>';
if(get_option('enable_hallnumber_in_role_report') == 1){
$tblhtml .= '<th  style="text-align:center;"><b>'._l('casediary_hallnumber').'</b></th>';
}
$tblhtml .= '<th  style="text-align:center;"><b>'._l('previous_decision').'</b></th>';
$tblhtml .= '<th  style="text-align:center;"><b>'._l('current_decision').'</b></th>';


$tblhtml .= '</tr>';
$tblhtml .= '</thead>';
$tblhtml .= '<tbody>';
foreach ($hearing as $aRow) {
	if(isset($aRow['company'])){
		$tblhtml .= '<tr>';
		$date2 = $date1 = '';
		if(isset($aRow['hearing_dates'])){
			$hearing_dates = explode('~',$aRow['hearing_dates']);
			$size_dates = sizeof($hearing_dates);
			$date2 = isset($hearing_dates[$size_dates-2]) ? '<b>'.$hearing_dates[$size_dates-2].'</b><br />' : ' ';
			$date1 = isset($hearing_dates[$size_dates-1]) ? '<b>'.$hearing_dates[$size_dates-1].'</b><br />' : ' ';
		}
		$dec2 = $dec1 = '';
		if(isset($aRow['decisions'])){
			$explode_decisions = explode('~',$aRow['decisions']);
			$size = sizeof($explode_decisions);
			$dec2 = isset($explode_decisions[$size-2]) ? $date2.$explode_decisions[$size-2] : ' ';
			$dec1 = isset($explode_decisions[$size-1]) ? $date1.$explode_decisions[$size-1] : ' ';
		}
		
		$tblhtml .= '<td  style="text-align:center;">'.$aRow['file_no'].'</td>';
		$tblhtml .= '<td  style="text-align:center;">'.nl2br($aRow['case_number']).'</td>';
		$client_position = '<br><span><strong>'.get_position_name_by_id($aRow['h_client_position']).'</strong></span>';
		$tblhtml .= '<td  style="text-align:center;">'.$aRow['company'].''.$client_position.'</td>';
		$opposite_party_position = '<br><span><strong>'.get_position_name_by_id($aRow['h_oppositeparty_position']).'</strong></span>';
		$tblhtml .= '<td  style="text-align:center;">'.$aRow['opposite_party'].''.$opposite_party_position.'</td>';
		if(get_option('enable_lawyer_in_role_report') == 1){
		$tblhtml .= '<td  style="text-align:center;">'.$aRow['lawyer_name'].'</td>';
		}
		$tblhtml .= '<td  style="text-align:center;">'.nl2br($aRow['court_id']).'</td>';
		$tblhtml .= '<td  style="text-align:center;" >'.$aRow['case_nature_name'].'</td>';
		if(get_option('enable_hallnumber_in_role_report') == 1){
			$tblhtml .= '<td  style="text-align:center;" >'.$aRow['hallnumber'].'</td>';
		}
		$tblhtml .= '<td  style="text-align:center;" >'.$dec1.'</td>';
		$tblhtml .= '<td  style="text-align:center;"></td>';

		$tblhtml .= '</tr>';
	}
}
$tblhtml .= '</tbody>';
$tblhtml .= '</table>';

$pdf->writeHTML($tblhtml, true, false, false, false, '');

?>